% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownames.R
\name{rownames}
\alias{rownames}
\alias{sqlColumnToRownames}
\alias{sqlRownamesToColumn}
\title{Convert row names back and forth between columns}
\usage{
sqlRownamesToColumn(df, row.names = NA)

sqlColumnToRownames(df, row.names = NA)
}
\arguments{
\item{df}{A data frame}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

  If \code{TRUE}, always translate row names to a column called "row_names".
  If \code{FALSE}, never translate row names. If \code{NA}, translate
  rownames only if they're a character vector.

  A string is equivalent to \code{TRUE}, but allows you to override the
  default name.

  For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}
}
\description{
These functions provide a reasonably automatic way of preserving the row
names of data frame during back-and-forth translation to a SQL table.
By default, row names will be converted to an explicit column
called "row_names", and any query returning a column called "row_names"
will have those automatically set as row names.
These methods are mostly useful for backend implementers.
}
\examples{
# If have row names
sqlRownamesToColumn(head(mtcars))
sqlRownamesToColumn(head(mtcars), FALSE)
sqlRownamesToColumn(head(mtcars), "ROWNAMES")

# If don't have
sqlRownamesToColumn(head(iris))
sqlRownamesToColumn(head(iris), TRUE)
sqlRownamesToColumn(head(iris), "ROWNAMES")

}

