% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbListFields}
\alias{dbListFields}
\title{List field names of a remote table}
\usage{
dbListFields(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{a character string with the name of the remote table.}

\item{...}{Other parameters passed on to methods.}
}
\value{
a character vector
}
\description{
List field names of a remote table
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
dbListFields(con, "mtcars")

dbDisconnect(con)
}
\seealso{
\code{\link[=dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
\concept{DBIConnection generics}
