\name{tango.boot}

\alias{tango.boot}
\alias{tango.pboot}

\title{Generate bootstrap replicated of Tango's statistic}

\description{
Generate bootstrap replicated of Tango's statistic for general clustering, by
means of function \emph{boot} from \emph{boot} library. Notice that these
functions should not be used separately but as argument \emph{statistic} when
calling function \emph{boot}.

\emph{tango.boot} is used when performing non-parametric bootstrap.

\emph{tango.pboot} must be used for parametric bootstrap.
}

\usage{
tango.boot(data, i, ...)
tango.pboot(...)
}

\arguments{
\item{data}{Dataframe with the data as described in \emph{DCluster}.}
\item{i}{Permutation generated by the non-parametric boostrap procedure.}
\item{...}{Additional arguments passed when performing a bootstrap.}
}


\value{
Both functions return the value of the statistic.
}


\examples{
library(boot)
library(spdep)

data(nc.sids)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74) )
sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)


#Calculate neighbours based on distance
coords<-as.matrix(sids[,c("x", "y")])

dlist<-dnearneigh(coords, 0, Inf)
dlist<-include.self(dlist)
dlist.d<-nbdists(dlist, coords)

#Calculate weights. They are globally standardised but it doesn't
#change significance.
col.W.tango<-nb2listw(dlist, glist=lapply(dlist.d, function(x) {exp(-x)}),
        style="C")
	
niter<-100


#Permutation model
tn.boot<-boot(sids, statistic=tango.boot, R=niter, listw=col.W.tango, 
	zero.policy=TRUE)
plot(tn.boot)#Display results

#Multinomial model
tn.mboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
	ran.gen=multinom.sim,  R=niter, listw=col.W.tango, zero.policy=TRUE)
		
plot(tn.mboot)#Display results

#Poisson model
tn.pboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
	ran.gen=poisson.sim,  R=niter, listw=col.W.tango, zero.policy=TRUE)
		
plot(tn.pboot)#Display results

#Poisson-Gamma model
tn.pgboot<-boot(sids, statistic=tango.pboot, sim="parametric", 
	ran.gen=negbin.sim, R=niter, listw=col.W.tango, zero.policy=TRUE)
plot(tn.pgboot)#Display results
}

\seealso{
DCluster, boot, tango, tango.stat
}

\references{
Tango, Toshiro (1995). A Class of Tests for Detecting 'General' and 'Focused' Clustering of Rare Diseases. Statistics in Medicine 14, 2323-2334.
}

\keyword{spatial}
