% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{BS}
\alias{BS}
\title{Estimated Density Values by Birnbaum-Saunders kernel}
\usage{
BS(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated Values by using Birnbaum-Saunders Kernel.
}
\details{
The Birnbaum-Saunders kernel is developed by Jin and Kawczak (2003). They claimed that performance of their developed kernel is better near the
boundary points in terms of boundary reduction.
\deqn{K_{BS(h^\frac{1}{2},x)} (y)=\frac{1}{2\sqrt 2 \pi h} \left(\sqrt \frac{1}{xy} +\sqrt\frac{x}{y^3}\right)exp\left(-\frac{1}{2h}\left(\frac{y}{x}-2+\frac{x}{y}\right)\right)}
}
\examples{
 y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
BS(y,200,h)
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
}
\seealso{
For further kernels see \code{\link{Erlang}}, \code{\link{Gamma}} and \code{\link{LN}}. To plot the density by using BS kernel \code{\link{plot.BS}} and to calculate MSE by using Birnbaum-Saunders Kernel \code{\link{mseBS}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
