% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\name{make.blocksraster}
\alias{make.blocksraster}
\alias{make.blocksraster,DeponsRaster-method}
\title{Makes new file with blocks}
\usage{
\S4method{make.blocksraster}{DeponsRaster}(
  template,
  blocks = NA,
  blockvals = NULL,
  NAvalue = -9999,
  plot = FALSE,
  fname = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{template}{DeponsRaster object used as template for new blocks file}

\item{blocks}{list of areas to be used for new blocks. Each item in 'blocks'
should be a matrix (with two columns, corresponding to x- and y-coordinates)
or a SpatialPolygons object}

\item{blockvals}{Vector of integer values defining the labels of the new blocks.
The first value defines the background value, so the length of 'blockvals'
should equal the number of blocks plus 1}

\item{NAvalue}{Value used for missing data in the output object}

\item{plot}{If TRUE, the raster block is plotted}

\item{fname}{Name of the output raster file (character string ending with
'.asc'). No file is written to disk if fname is not provided.}

\item{overwrite}{Whether to replace existing file.}
}
\value{
\code{RasterLayer} object defining different subregions of the
landscape where animals should be counted.
}
\description{
Produces a DeponsRaster object of type='blocks' for use in DEPONS
simulations. This allows animals to be counted within specific regions (blocks)
of the landscape during the simulation. The new blocks can be specified as
either matrices or SpatialPolygons objects. For matrices, the blocks are
defined as the smallest rectangle that includes all the specified positions.
}
\note{
The blocks file should not be modified when running DEPONS
simulations using the 'Kattegat' landscape. In this landscape the simulated
animals use the blocks file for navigation. Also note that blocks are added
to the new blocks raster in the order they are file in the order in which
they are listed in 'blocks', so the order mattes if the blocks overlap.
}
\examples{
#Load file to use as template for new blocks file
data("bathymetry")

# Make list of blocks to create
new.blocks <- list()
x <- runif(8, 700000, 760000)
y <- runif(8, 6200000, 6300000)
new.blocks[[1]] <- cbind(x,y)
x <- c(600000, 635000, 670000, 635000)
y <- c(6150000, 6200000, 6150000, 6100000)
library(sp)
srl <- list(Polygon(cbind(x,y)))
Srl <- list(Polygons(srl, ID=as.vector("p")))
new.blocks[[2]] <- SpatialPolygons(Srl, proj4string=crs(bathymetry))

make.blocksraster(bathymetry, new.blocks, plot=TRUE)
points(new.blocks[[1]])
plot(new.blocks[[2]], add=TRUE)

\donttest{
the.dir <- tempdir()
make.blocksraster(bathymetry, new.blocks, fname=paste0(the.dir, "/test.asc"))
}
}
