% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detcurve.R
\name{detc}
\alias{detc}
\title{DET Curve calculation}
\usage{
detc(responses, predictors, names = c(""), positive = "", title = "",
  legend = "topright", file, plotROC = FALSE, xlim = c(0.05, 50),
  ylim = c(0.05, 50))
}
\arguments{
\item{responses}{A dataframe of factor, numeric or character vector of responses, typically encoded with 0 (non-target) and 1 (target).  By default, the first two values of levels(as.factor(response)) are taken. If only one response is passed, 
it will be used for calculating all the curves.}

\item{predictors}{A dataframe of numeric vector of the same length than response, containing the predicted value of each observation. An ordered factor is coerced to a numeric.}

\item{names}{Array of strings, containing the name of each pair (response,predictor) that will appear in the legend of the graph.}

\item{positive}{string with the name of the 'positive' class. Default: negative class will be the first string of response levels and positive class the second string.}

\item{title}{Main tile for the graph}

\item{legend}{the location of the leyend in the graph. Could be a single keyword from the list "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center" and NULL. Default: "topright".}

\item{file}{The name of the file where the plot will be saved. If Empty, the DET and ROC curves are plotted by the graphic output.}

\item{plotROC}{Boolean specifying ploting or not the ROC Curve}

\item{xlim}{numeric vector of length 2, giving the x coordinates range.}

\item{ylim}{numeric vector of length 2, giving the y coordinates range.}
}
\value{
A list of dataframe, one per classifier. Each dataframe contains the name of the classifier, and the 
parameters of the DET curve (FPR, FNR and the thresholds used), along with the Equal Error Rate (%).
}
\description{
From a dataframe of responses and predictors, the function calculates and plots the DET curves for each pair (response,predictor). In addition, ROC curves can be displayed by activating a boolean argument.
}
\examples{
n <- 5000
set.seed(12345)
#Predictors with normal distribution
set.seed(1235)
scoreNegative <- rnorm(n, mean = 0.25,sd = 0.125) 
set.seed(11452)
scorePositive1 <- rnorm(n, mean = 0.55,sd = 0.125)
set.seed(54321)
scorePositive2 <- rnorm(n, mean = 0.65,sd = 0.125)
set.seed(65987)
scorePositive3 <- rnorm(n, mean = 0.75,sd = 0.125) 
response = c(rep(c("target"), times = n),rep(c("nontarget"), times = n))
predictor1 = c(scoreNegative,scorePositive1)
predictor2 = c(scoreNegative,scorePositive2)
predictor3 = c(scoreNegative,scorePositive3)
responses <- data.frame(
  response = response
)
predictors <- data.frame(
  DET1 = predictor1,
  DET2 = predictor2,
  DET3 = predictor3
)
#We can also plot the ROC curves activating logical attribute 'plotROC'
detcurve <- detc(responses,predictors,
                names = names(predictors),
                positive="target",
                title="Example",
                plotROC = TRUE)
 

}
