% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detc.R
\name{detc.ci}
\alias{detc.ci}
\title{DET Curve calculation with CI}
\usage{
detc.ci(
  dets = NULL,
  conf = 0.95,
  positive = "",
  parallel = TRUE,
  ncores = detectCores(),
  nboot = 2000,
  plot = FALSE,
  ...
)
}
\arguments{
\item{dets}{A 'DETs' object which will be used to extract or compute the CIs of the DET curves.}

\item{conf}{A single numeric value into the (0,1) interval,  which represents the confidence level of the CI of the DET Curve. Default: \code{conf = 0.95}.}

\item{positive}{A string with the name of the 'positive' level which is setting as reference level of 'response'.}

\item{parallel}{Boolean. By default \code{parallel = TRUE}. If TRUE, the bootstrap method to calculated the CI is processed in parallel, using the backend provided by \code{plyr} (foreach).}

\item{ncores}{The number of nodes to be forked for the parallel computation of the CI. Default: the maximum available. None used if \code{parallel = FALSE}.}

\item{nboot}{The number of bootstrap replicates to be used for the computation of the CI. Default: \code{nboot = 2000}.}

\item{plot}{If TRUE, the CIs will be plotted for the DET curves. Default: \code{plot = FALSE}.}

\item{...}{Further attributes that will be passed to the \code{plot} function.}
}
\value{
A 'DETs' object containing the list of DET curves with their CIs, one per classifier.
}
\description{
From a 'DETs' object, the function extracts either computes the confidence interval (CI) of each DET curve of the object.
}
\examples{
\donttest{
library(DET)
n = 500
#Predictors with normal distribution
set.seed(1235)
scoreNegative1 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(5321)
scoreNegative2 = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(11452)
scorePositive1 = rnorm(n, mean = 0.55, sd = 0.125)
set.seed(54321)
scorePositive2 = rnorm(n, mean = 0.65, sd = 0.125)
response = as.factor(c(rep(c("target"), times = n), rep(c("nontarget"), times = n)))
predictor1 = c(scoreNegative1, scorePositive1)
predictor2 = c(scoreNegative2, scorePositive2)
predictors = matrix(c(predictor1, predictor2), ncol = 2)
colnames(predictors) = c("DET1", "DET2")
detCurves = detc(
  response,
  predictors,
  positive = "target",
  names = colnames(predictors)
)

#Run in parallel for a faster execution activating logical argument 'parallel'
#and setting the number of cores of your computer
#logical argument 'parallel'
detCurvesWithConfidenceInterval = detc.ci(
  dets = detCurves,
  positive = "target",
  names = colnames(predictors),
  conf = 0.95,
  parallel = TRUE
)
}
}
