% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{extractPLAF}
\alias{extractPLAF}
\title{Extract PLAF}
\usage{
extractPLAF(plafFileName)
}
\arguments{
\item{plafFileName}{Path of the PLAF text file.}
}
\value{
A numeric array of PLAF
}
\description{
Extract population level allele frequency (PLAF) from text file.
}
\note{
The text file must have header, and population level allele frequency recorded in the "PLAF" field.
}
\examples{
plafFile = system.file("extdata", "labStrains.test.PLAF.txt", package = "DEploid")
plaf = extractPLAF(plafFile)

}
