% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{plotObsExpWSAF}
\alias{plotObsExpWSAF}
\title{Plot WSAF}
\usage{
plotObsExpWSAF(obsWSAF, expWSAF, title = "WSAF(observed vs expected)",
  cex.lab = 1, cex.main = 1, cex.axis = 1)
}
\arguments{
\item{obsWSAF}{Numeric array of observed WSAF.}

\item{expWSAF}{Numeric array of expected WSAF.}

\item{title}{Figure title.}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}
}
\description{
Plot observed alternative allele frequency within sample against
 expected WSAF.
}
\examples{
\dontrun{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
plafFile = system.file("extdata", "labStrains.test.PLAF.txt",
 package = "DEploid")
PG0390CoverageV.deconv = dEploid(paste("-vcf", vcfFile,
                                       "-plaf", plafFile, "-noPanel"))
prop = PG0390CoverageV.deconv$Proportions[dim(PG0390CoverageV.deconv$Proportions)[1],]
expWSAF = t(PG0390CoverageV.deconv$Haps) \%*\% prop
plotObsExpWSAF(obsWSAF, expWSAF)
}

}
