% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCorMats.R
\name{dCorMats}
\alias{dCorMats}
\title{Finds differential correlations between matrices.}
\usage{
dCorMats(matA, nmatA, matB, nmatB, corr_cutoff = 0.99, corrType = "pearson",
  secondMat = FALSE, signType = "none")
}
\arguments{
\item{matA}{Correlation matrix with numeric entries.}

\item{nmatA}{Number of samples (nsamp) matrix with numeric entries, corresponding to the number of samples used for each of the correlations calculated in matA.}

\item{matB}{Correlation matrix with numeric entries.}

\item{nmatB}{Number of samples (nsamp) matrix with numeric entries, corresponding to the number of samples used for each of the correlations calculated in matB.}

\item{corr_cutoff}{Cutoff specifying correlation values beyond which will be truncated to this value, to reduce the effect of outlier correlation values when using small sample sizes. Note that this does NOT affect the reported underlying correlation values, but does affect the z-score difference of correlation calculation.}

\item{corrType}{The correlation type of the analysis, limited to "pearson" or "spearman".}

\item{secondMat}{Logical indicator of whether there is a second matrix in the comparison or not. If no, then computations will only be performed the upper triangle of the input matrices.}

\item{signType}{Coerce all correlation coefficients to be either positive (via "positive"), negative (via "negative"), or none (via "none"). This could be used if you think that going from a positive to a negative correlation is unlikely to occur biologically and is more likely to be due to noise, and you want to ignore these effects. Note that this does NOT affect the reported underlying correlation values, but does affect the z-score difference of correlation calculation. Default = "none", for no coercing.}
}
\value{
A list of two differential correlation matrices: one for the difference in z-scores and one for the corresponding p-values.
}
\description{
Takes two corresponding correlation and nsamp matrices and returns matrices for the scaled difference in correlation as well as the p-value of that difference.
}

