% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getType}
\alias{getType}
\title{Retrieve data items by type}
\usage{
getType(dgeObj, type, parent)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{type}{A type or list of types to retrieve}

\item{parent}{(optional) Filter return list for common parent (e.g. useful
to select one set of contrast results when multiple fits have been performed)}
}
\value{
A list of data items
}
\description{
Retrieve data items by type
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    MyContrastList <- getType(exObj, type = "topTable")
    MyRawData      <- getType(exObj, type = list("counts", "design", "geneData"))

}
