% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{setAttributes}
\alias{setAttributes}
\title{Set attributes}
\usage{
setAttributes(dgeObj, attribs)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{attribs}{A named list of attribute/value pairs}
}
\value{
A DGEobj
}
\description{
Set one or more attributes on a DGEobj or on a specific item within a DGEobj.
}
\details{
This function adds attributes without deleting the attributes that are already
present. Any named attribute that already exists in the object will be updated.
To remove an attribute from an object pass NULL as the attribute value.
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    # Assign attributes to a DGEobj
    MyAttributes <- list(Platform       = "RNA-Seq",
                         Instrument     = "HiSeq",
                         Vendor         = "Unknown",
                         readType       = "PE",
                         readLength     = 75,
                         strandSpecific = TRUE)
    exObj <- setAttributes(exObj, MyAttributes)

    # Set attributes on an item inside a DGEobj
    MyAttributes <- list(normalized   = FALSE,
                         LowIntFilter = "FPK >5 in >= 1 group")
    exObj[["counts"]] <- setAttributes(exObj[["counts"]], MyAttributes)

}
