% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_hP.R
\name{hP}
\alias{hP}
\alias{dhP}
\alias{phP}
\alias{rhP}
\title{The hyper-Poisson Distribution}
\usage{
dhP(x, gamma, lambda)

phP(q, gamma, lambda, lower.tail = TRUE)

rhP(n, gamma, lambda)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{gamma}{dispersion parameter. Must be strictly positive.}

\item{lambda}{location parameter. Must be strictly positive.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are
\eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dhP} gives the density, \code{phP} gives the distribution
  function and \code{rhP} generates random deviates.

  Invalid \code{gamma} or \code{lambda} will result in return value
  \code{NaN}, with a warning.

  The length of the result is determined by n for \code{rhP}, and is the
  maximum of the lengths of the numerical arguments for the other functions.

  The numerical arguments other than \code{n} are recycled to the length of
  the result. Only the first element of the logical arguments is used.
}
\description{
Density, distribution function and random generation for the hyper-Poisson
distribution with parameters \code{gamma} and \code{lambda}.
}
\examples{
dhP(3, 15, 2)
phP(3, 15, 2)
rhP(10, 15, 2)
}
