% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{getCone}
\alias{getCone}
\title{calculate a cone}
\usage{
getCone(radius = 0.5, height = 1, faces = 72, close = FALSE)
}
\arguments{
\item{radius}{the outer radius of the cone}

\item{height}{the height of the cone}

\item{faces}{number of triangular sides}

\item{close}{logical should the bottom side be closed.}
}
\value{
a \code{\link{TriangBody-class}}
}
\description{
calculate a cone
}
\examples{
if (require(rgl)) {
  cone=getCone(faces=13, close=TRUE)
  triangles3d(cone@vertices[cone@id, ], col="green")
} else {
  message("the library 'rgl' is required for this example!")
}
}
