% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkUniformity.R
\name{benchmarkUniformity}
\alias{benchmarkUniformity}
\title{Uniformity benchmarks}
\usage{
benchmarkUniformity(dataModelCreator, nSim = 100, plot = T, ...)
}
\arguments{
\item{dataModelCreator}{a function that returns a list with two elements, data and model. See help for details}

\item{nSim}{number of simulations}

\item{plot}{should a plot be created}

\item{...}{parameters to pass on to \code{\link{simulateResiduals}}}
}
\description{
This function runs simulation to confirm uniformity of residuals under H0
}
\details{
This function runs repeated simulations to test of residuals are really uniform if the data-creating process and the model that is used to fit the data are identical
}
\note{
The benchmark function in DHARMa are intended for development purposes, and for users that want to test / confirm the properties of functions in DHARMa. If you are running an applied data analysis, they are probably of little use.
}
\examples{
library(lme4)

dataModelCreator <- function(){
  data = createData(sampleSize = 100, overdispersion = 0, family = poisson())
  model <- glmer(observedResponse ~ Environment1 + (1|group) + 
    (1|ID), data = data, family = "poisson")  
  return(list(data=data, model = model))
}

benchmarkUniformity(dataModelCreator = dataModelCreator, nSim = 5)
}
\seealso{
\code{\link{benchmarkOverdispersion}}
}

