## ---- eval = FALSE-------------------------------------------------------
#  install.packages("DHS.rates")

## ------------------------------------------------------------------------
library(DHS.rates)
data("AWIR70")
data("EMIR70")
data("ADBR70")

## ---- eval=FALSE---------------------------------------------------------
#  library(haven)
#  XXIR70 <- read_dta("C:\\Users\\.............................\\XXIR7HFL.DTA")
#  XXIR70 <- as.data.frame(XXIR70)
#  

## ------------------------------------------------------------------------
(TFR <- fert(AWIR70,Indicator="tfr"))

## ------------------------------------------------------------------------
(TFR <- fert(AWIR70,Indicator="tfr",JK="Yes"))

## ------------------------------------------------------------------------
(GFR <- fert(EMIR70,Indicator="gfr",EverMW="YES",AWFact="awfactt"))

## ------------------------------------------------------------------------
(ASFR <- fert(AWIR70,Indicator="asfr"))

## ------------------------------------------------------------------------
(TFR <- fert(AWIR70,Indicator="tfr",JK="Yes", Class="v025"))

## ------------------------------------------------------------------------
(GFR <- fert(EMIR70,Indicator="gfr", EverMW="YES",AWFact="awfactu", Class="v025"))

## ------------------------------------------------------------------------
(chmort(ADBR70))

## ------------------------------------------------------------------------
(chmort(ADBR70,JK="Yes"))

## ------------------------------------------------------------------------
(chmort(ADBR70,Period = 120))

## ------------------------------------------------------------------------
(chmort(ADBR70,Period = 120, PeriodEnd = "2013-09"))

## ------------------------------------------------------------------------
(chmortp(ADBR70))

