% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predict.DIFtree.R
\name{predict.DIFtree}
\alias{predict.DIFtree}
\title{Prediction of item difficulties of Item focussed Trees}
\usage{
\method{predict}{DIFtree}(object, items, X, ...)
}
\arguments{
\item{object}{object of class \code{\link[DIFtree]{DIFtree}}}

\item{items}{number of items, for which the prediction shall be returned}

\item{X}{new data.frame, for which the prediction shall be returned}

\item{...}{further arguments passed to or from other methods}
}
\description{
The function returns predictions of item difficulties
based on the estimated trees by item focussed recursive partitioning.
}
\examples{
data(data_sim)

Y <- data_sim[,1]
X <- data_sim[,-1]

Xnew <- data.frame("x1"=c(0,1),"x2"=c(-1.1,2.5),"x3"=c(1,0),"x4"=c(-0.2,0.7))

\dontrun{

mod <- DIFtree(Y=Y,X=X,alpha=0.05,nperm=100,trace=TRUE)

predict(mod,items=c(1,2,3),Xnew)
}
}
\author{
Moritz Berger <moritz.berger@stat.uni-muenchen.de> \cr \url{http://www.statistik.lmu.de/~mberger/}
}
\references{
Tutz, Gerhard and Berger, Moritz (2015): Item Focused Trees for the Identification of Items
in Differential Item Functioning, Department of Statistics, LMU Munich
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{plot.DIFtree}}
}

