% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XLloadfuns.r
\name{OM_xl}
\alias{OM_xl}
\title{Read in operating model parameters from Excel spreadsheet}
\usage{
OM_xl(fname, stkname, fpath = '', saveCSV = FALSE)
}
\arguments{
\item{fname}{Name of the Excel spreadsheet file. Must include file
extension.}

\item{stkname}{Name of the Stock.}

\item{fpath}{Full file path, if file is not in current working directory}

\item{saveCSV}{Do you also want to save the Stock, Fleet and Observation
parameters to CSV files?}
}
\value{
A object of class OM
}
\description{
A function to read in operating model parameters from an Excel spreadsheet
with tabs named following specific convention.
}
\details{
The Excel spreadsheet must have tabs named with the following convention.
For example if \code{stkname} is 'myFish', the Stock parameters are in a tab
named 'myFishStock'', Fleet parameters in a tab named 'myFishFleet', and
Observation parameters in a tab named 'myFishObs'. All three tabs (Stock,
Fleet and Obs) must be present for a single stock. You can have multiple
stocks in a single spreadsheet, provided that the stock names are different.
}
\examples{

\dontrun{
OM <- OM_xl(fname='OMTables.xlsx', stkname='myFish')
}

}
\author{
A. Hordyk
}
