% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Mixed.R
\name{Itarget1_MPA}
\alias{Itarget1_MPA}
\title{Itarget1 with an MPA}
\usage{
Itarget1_MPA(x, Data, reps = 100, plot = FALSE, yrsmth = 5, xx = 0,
  Imulti = 1.5)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{yrsmth}{Years over which to smooth recent estimates of surplus
production}

\item{xx}{Parameter controlling the fraction of mean catch to start using in
first year}

\item{Imulti}{Parameter controlling how much larger target CPUE / index is
compared with recent levels.}
}
\value{
An object of class \code{\link[=Rec-class]{Rec}} with the TAC, Spatial slot(s) populated
}
\description{
A example mixed control MP that uses the Itarget1 output control MP together with a
spatial closure.
}
\details{
The TAC is calculated as:
If  \eqn{I_\textrm{recent} \geq I_0}:
\deqn{\textrm{TAC}= 0.5 \textrm{TAC}^* \left[1+\left(\frac{I_\textrm{recent} - I_0}{I_\textrm{target} - I_0}\right)\right]}

else:
\deqn{\textrm{TAC}= 0.5 \textrm{TAC}^* \left[\frac{I_\textrm{recent}}{I_0}^2\right]}

where \eqn{I_0} is \eqn{0.8 I_{\textrm{ave}}} (the average index over the 2 x \code{yrsmth} years prior to the projection period),
\eqn{I_\textrm{recent}} is the average index over the past \code{yrsmth} years, and
\eqn{I_\textrm{target}} is \code{Imulti} times \eqn{I_{\textrm{ave}}},
and \eqn{\textrm{TAC}^*} is:
\deqn{(1-x)C}
where \eqn{x} is argument \code{xx} and C is the average catch over the last 5 years of the historical period.

This mixed control MP also closes Area 1 to fishing.

This MP has been included for demonstration purposes of a mixed control MP.
}
\section{Required Data}{

See \linkS4class{Data} for information on the \code{Data} object \cr


\code{Itarget1_MPA}: Cat, Ind, LHYear, Year
}

\section{Rendered Equations}{

See \href{https://dlmtool.github.io/DLMtool/reference/Itarget1_MPA.html}{Online Documentation} for correctly rendered equations
}

\examples{
Itarget1_MPA(1, DLMtool::Atlantic_mackerel, plot=TRUE)
}
\seealso{
Other Index methods: \code{\link{GB_slope}},
  \code{\link{GB_target}}, \code{\link{Gcontrol}},
  \code{\link{ICI}}, \code{\link{Iratio}},
  \code{\link{Islope1}}, \code{\link{Itarget1}},
  \code{\link{ItargetE1}}
}
\concept{Index methods}
