% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drsummary.R
\name{drsummary}
\alias{drsummary}
\title{Performs a summary of a set of differential risk hotspots located along a linear network}
\usage{
drsummary(
  X,
  rel_probs,
  hotspots,
  order_extension = NULL,
  compute_p_value = F,
  n_it = 40
)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a linear network (\code{linnet} object)}

\item{rel_probs}{- An object containing the relative probabilities of a specific type of event along the linear network contained in \code{X}, generated through the function \code{relpnet}}

\item{hotspots}{- A set of differential risk hotspots obtained with the function \code{DiffHotspots_n_k}}

\item{order_extension}{- A natural number indicating a neighbourhood order to be used for constructing an extension of the differential risk hotspots. The summary is also given for the segments forming this extension}

\item{compute_p_value}{- A logical value allowing the user to compute a p-value representing the statistical significance of each differential risk hotspot. It is set to FALSE by default}

\item{n_it}{- Number of simulations performed for the estimation of the p-value (if \code{compute_p_value} = \code{T})}
}
\value{
Returns a \code{data.frame} providing a summary of a set of differential risk hotspots. Each row of the output corresponds to one hotspot
}
\description{
This function provides a basic summary of each differential risk hotspot provided in the object \code{hotspots} passed to the function. This includes the proportion of the type of event in each hotspot, the total length of the hotspot, a type-specific prediction accuracy index (\code{PAI_t}). Furthermore, this summary is also provided for an extension of each of the hotspots
}
\examples{
library(DRHotNet)
library(spatstat.geom)
library(spatstat.linnet)
library(spdep)
library(raster)
library(maptools)
\donttest{
rel_probs_rear_end <- relpnet(X = SampleMarkedPattern, 
lixel_length = 50, h = 100, mark = "Collision", category_mark = "Rear-end")
hotspots_rear_end <- drhot(X = SampleMarkedPattern, rel_probs = rel_probs_rear_end, 
k = 1, n = 30)
hotspots_summary <- drsummary(X = SampleMarkedPattern, rel_probs = rel_probs_rear_end, 
hotspots = hotspots_rear_end)
}
}
