\name{drcorrelate.null}
\alias{drcorrelate.null}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Generate null distribution for DR-Correlate analysis }
\description{
  A null distribution is generated by randomly permuting the sample labels of the 
	gene expression data matrix and recomputing the DNA/RNA correlations for each gene.
}
\usage{
drcorrelate.null(DNA, RNA, method = "pearson", tail_p = 10, perm)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{DNA}{ matrix of DNA copy number data }
  \item{RNA}{ matrix of gene expression data, samples (columns) in same order as DNA matrix }
  \item{method}{ correlation statistic, either "pearson", "spearman", or "ttest" }
  \item{tail_p}{ top/bottom percent of samples (with respect to the gene's copy number) to use
			 for extremes t-test groups; used only when method = "ttest" }
  \item{perm}{ number of permutations to perform }
}
\details{
}
\value{
  \item{null}{ n * k matrix of null data, where n = number of genes and k = number of permutations }
}
\references{ 
Salari, K., Tibshirani, R., and Pollack, J.R. (2009) DR-Integrator: a new analytic tool for integrating 
DNA copy number and gene expression data. http://pollacklab.stanford.edu/
}
\author{ Keyan Salari, Robert Tibshirani, and Jonathan R. Pollack }
\note{
}
\seealso{
\code{\link{drcorrelate}},\code{\link{drcorrelate.null}},\code{\link{drsam}},
\code{\link{drsam.null}},\code{\link{dri.fdrCutoff}},\code{\link{dri.sig_genes}},\code{\link{dri.heatmap}}
}
\examples{
require(impute)
data(mySampleData)
attach(mySampleData)

# DNA data should contain no missing values - pre-mooth beforehand
# Impute missing values for gene expression data
RNA.data <- dri.impute(RNA.data)

# DR-Correlate analysis to find genes with correlated DNA/RNA measurements
obs <- drcorrelate(DNA.data, RNA.data, method="pearson")
# generate null distribution for FDR calculation (10 permutations)
null <- drcorrelate.null(DNA.data, RNA.data, method="pearson", perm=10)
# identify the correlation cutoff corresponding to your desired FDR
n.cutoff <- dri.fdrCutoff(obs, null, targetFDR=0.05, bt=TRUE)
cutoff <- n.cutoff[2]
# retrieve all genes that are significant at the determined cutoff, and calculate gene-specific FDRs
Results <- dri.sig_genes(cutoff, obs, null, GeneIDs, GeneNames, Chr, Nuc, bt=TRUE, method="drcorrelate") 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{}
\keyword{}% __ONLY ONE__ keyword per line
