% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRaWR.R
\name{RWR}
\alias{RWR}
\title{RWR}
\usage{
RWR(boolSparceMat, transmat, restart, query, startvec, maxiters, thresh)
}
\arguments{
\item{boolSparceMat}{(bool): Boolean to indicate sparce Matrix or list matrix.}

\item{transmat}{(sparce Matrix / list matrix): transition probabilites.}

\item{restart}{(float): probability of restart.}

\item{query}{(vector): probability of restarting at all nodes.}

\item{startvec}{(vector): initial probability of being at any node.}

\item{maxiters}{(int): maximum number of allowable iterations.}

\item{thresh}{(float): threshold for L1 norm convergence.}
}
\value{
list of 'iter':number of iterations, 'diff': L1 norm of difference, 'vec': converged probability distribution vector.
}
\description{
This function runs a random walk with restart using two supported matrix representations.
}
\examples{
RWR(boolSparceMat=TRUE, transmat=transmat, restart=.3, query=c(rep(0.1,10),rep(0,5)),
	startvec=rep(1/15,15), maxiters=10, thresh=0.001)
}
\keyword{random}
\keyword{restart}
\keyword{walk}
\keyword{with}

