% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_Vector_transmission_model_ode.R
\name{simulate_Vector_transmission_model_ode}
\alias{simulate_Vector_transmission_model_ode}
\title{Vector transmission model}
\usage{
simulate_Vector_transmission_model_ode(
  Sh = 1000,
  Ih = 1,
  Rh = 0,
  Sv = 1000,
  Iv = 1,
  b1 = 0.003,
  b2 = 0.003,
  g = 2,
  w = 0,
  n = 200,
  m = 0.1,
  tstart = 0,
  tfinal = 100,
  dt = 0.1
)
}
\arguments{
\item{Sh}{: starting value for Susceptible hosts : numeric}

\item{Ih}{: starting value for Infected hosts : numeric}

\item{Rh}{: starting value for Recovered hosts : numeric}

\item{Sv}{: starting value for Susceptible Vectors : numeric}

\item{Iv}{: starting value for Infected Vectors : numeric
Values for model parameters : numeric}

\item{b1}{: rate at which susceptible hosts are infected by vectors : numeric}

\item{b2}{: rate at which susceptible vectors are infected by hosts : numeric}

\item{g}{: recovery rate of hosts : numeric}

\item{w}{: wanning immunity rate : numeric}

\item{n}{: vector birth rate : numeric}

\item{m}{: vector death rate : numeric
Values for model times : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic model with several compartments to model vector-borne transmission
}
\details{
The model tracks the dynamics of susceptible, infected, and recovered hosts, and susceptible and infected vectors. Infection, recovery, and waning immunity processes are implemented for hosts. Births and deaths and infection processes are implemented for vectors.

This code is was generated by the modelbuilder package R.  
The model is implemented as a set of ordinary differential equations using the deSolve package. 
The following R packages need to be loaded for the function to work: deSolve. 

Starting conditions for model variables
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2020-09-01
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2020-09-01
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_Vector_transmission_model_ode() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_Vector_transmission_model_ode(Sh = 2000,Ih = 2,Rh = 0,Sv = 2000,Iv = 2) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'Sh'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of Sh: ',max(result$ts[,'Sh']))) 
}
