% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_modelvariants_ode.R
\name{simulate_modelvariants_ode}
\alias{simulate_modelvariants_ode}
\title{Simulation of a viral infection model with immune response
The simulation illustrates different alternative models.}
\usage{
simulate_modelvariants_ode(
  U = 1e+05,
  I = 0,
  V = 10,
  F = 0,
  A = 0,
  n = 0,
  dU = 0,
  dI = 1,
  dV = 4,
  b = 1e-05,
  p = 100,
  pF = 1,
  dF = 1,
  f1 = 1e-04,
  f2 = 0,
  f3 = 0,
  Fmax = 1000,
  sV = 1e-10,
  k1 = 0.001,
  k2 = 0,
  k3 = 0,
  a1 = 1000,
  a2 = 0,
  a3 = 0,
  hV = 1e-10,
  k4 = 0.001,
  k5 = 0,
  k6 = 0,
  sA = 1e-10,
  dA = 0.1,
  tstart = 0,
  tfinal = 20,
  dt = 0.01
)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{F}{: initial level of innate response : numeric}

\item{A}{: initial level of adaptive response : numeric}

\item{n}{: rate of uninfected cell production : numeric}

\item{dU}{: rate of natural death of uninfected cells : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{pF}{: rate of innate response production in absence of infection : numeric}

\item{dF}{: rate of innate response removal in absence of infection : numeric}

\item{f1}{: growth of innate response alternative 1 : numeric}

\item{f2}{: growth of innate response alternative 2 : numeric}

\item{f3}{: growth of innate response alternative 3 : numeric}

\item{Fmax}{: maximum level of innate response in alternative 1 : numeric}

\item{sV}{: saturation of innate response growth in alternative 2 and 3 : numeric}

\item{k1}{: action of innate response alternative 1 : numeric}

\item{k2}{: action of innate response alternative 2 : numeric}

\item{k3}{: action of innate response alternative 3 : numeric}

\item{a1}{: growth of adaptive response alternative 1 : numeric}

\item{a2}{: growth of adaptive response alternative 2 : numeric}

\item{a3}{: growth of adaptive response alternative 3 : numeric}

\item{hV}{: saturation of adaptive response growth in alternative 2 and 3 : numeric}

\item{k4}{: action of adaptive response alternative 1 : numeric}

\item{k5}{: action of adaptive response alternative 2 : numeric}

\item{k6}{: action of adaptive response alternative 3 : numeric}

\item{sA}{: saturation of adaptive response killing for alternative action 2 : numeric}

\item{dA}{: adaptive immune response decay : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Times for which result is returned : numeric}
}
\value{
The function returns the output from the odesolver as a matrix,
with one column per compartment/variable. The first column is time.
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a matrix containing time-series of each variable and time.
}
\details{
A compartmental infection model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values),
  the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_modelvariants_ode()
# To choose parameter values other than the standard one, specify them, like such:
result <- simulate_modelvariants_ode(V = 100, k1 = 0 , k2 = 0, k3 = 1e-4)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,"time"],result$ts[,"V"],xlab='Time',ylab='Virus',type='l',log='y')
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
