% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsHasTable}
\alias{dsHasTable}
\title{Check remote table exists}
\usage{
dsHasTable(conn, table)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{table}{the table fully qualified name}
}
\description{
Check if a remote table exists in the data repository. Returns a logical indicating the existence of a
remote table accessible through this connection.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsHasTable")}
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsHasTable(con, "test.CNSIM")
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsIsAsync}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
