% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_eco.R
\name{write_eco}
\alias{write_eco}
\title{Reads parameters from a single DSSAT ecotype parameter file (*.ECO)}
\usage{
write_eco(eco, file_name)
}
\arguments{
\item{eco}{a DSSAT_tbl containing the contents of a DSSAT ecotype parameter file}

\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}
}
\value{
a tibble containing the data from the raw DSSAT output
}
\description{
Reads parameters from a single DSSAT ecotype parameter file (*.ECO)
}
\examples{

# Extract file path for sample ecotype file path
sample_eco_file <- system.file('extdata','SAMPLE.ECO',package='DSSAT')

# Read sample ecotype file
eco <- read_eco(sample_eco_file)

# Create example ecotype file path
sample_eco_file2 <- paste0(tempdir(),'/SAMPLE.ECO')

# Write out sample ecotype file
write_eco(eco,sample_eco_file2)

}
