fluidPage(
    fluidRow(
        bs4Box(
            title="Constraint settings",
            width=4,
            radioButtons("constrIn", label=h4("Define constraints"),
                         list("Use built-in constraints"=1,
                              "Upload constraints"=2,
                              "Paste constraints"=3)),
            conditionalPanel(condition="input.constrIn == '2'",
                             h5("Upload constraints: "),
                             fileInput("constrUpload", "Select constraint file:", multiple=FALSE),
                             radioButtons("constrDec", "Decimal separator:",
                                          list("."=1, ","=2)),
                             radioButtons("constrSep", "Column separator:",
                                          list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4),
                                          selected=2)),
            conditionalPanel(condition="input.constrIn == '3'",
                             h5("Paste constraints:"),
                             tags$textarea(id="constrPaste", rows=4, cols=10, ""),
                             radioButtons("constrPasteDec", "Decimal separator:",
                                          list("."=1, ","=2)),
                             radioButtons("constrPasteSep", "Column separator:",
                                          list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4),
                                          selected=2)),
            actionButton("applyConstraints", "Apply"),
            #radioButtons("constrInterp", label=h5("DVH interpolation"),
            #             list("Linear"=1,
            #                  "Monotone spline"=2,
            #                  "Local polynomial"=3)),
            checkboxInput("constrEUDparam", "Show EUD params ...", FALSE),
            conditionalPanel(condition="input.constrEUDparam == true",
                             textInput("constrEUDa", h5("exponent a"), value=""),
                             textInput("constrEUDfd", h5("fraction dose"), value=""),
                             textInput("constrEUDab", h5("alpha/beta ratio"), value="")
            ),
            checkboxInput("constrNTCPparam", "Show (N)TCP params ...", FALSE),
            conditionalPanel(condition="input.constrNTCPparam == true",
                             radioButtons("constrNTCPtype", h5("(N)TCP Model"),
                                          list("Probit (Lyman KB)"=1,
                                               "Logit (Niemierko)"=2,
                                               "Probit (Kaellman)"=3)),
                             textInput("constrNTCPtd50", h5("T(C)D50"), value=""),
                             textInput("constrNTCPn", h5("n (=1 / EUD-a)"), value=""),
                             conditionalPanel(condition="input.constrNTCPtype == '1'",
                                              textInput("constrNTCPm", h5("Lyman m"), value="")
                             ),
                             conditionalPanel(condition="input.constrNTCPtype != '1'",
                                              textInput("constrNTCPgamma50", h5("Logit/Poisson gamma50"), value="")
                             )
            ),
            h4("Output table options"),
            checkboxInput("constrSemSign", "Semantic negative sign", TRUE),
            selectizeInput("constrOut", label=h5("Select table columns"),
                           choices=constrOut, multiple=TRUE,
                           selected=c("1", "2", "3", "4", "5", "7", "9", "10", "11"),
                           width="100%"),
            selectizeInput("constrSortBy", label=h5("Sort output table by:"),
                           choices=c("Compliance"=1,
                                     "Distance"=2,
                                     "Delta volume"=3,
                                     "Delta dose"=4,
                                     "Observed"=5,
                                     "Constraint"=6,
                                     "Patient ID"=7,
                                     "Structure"=8),
                           multiple=TRUE)#,
            #options=c(placeholder='Click to select variables'))
        ),
        bs4Box(
            title="Check constraints",
            width=8,
            DT::dataTableOutput("constraints"),
            downloadButton("saveConstrTxt", "Save as text file"),
            inputPanel(
                radioButtons("saveConstrDec", "Decimal separator:",
                             list("."=1, ","=2)),
                radioButtons("saveConstrSep", "Column separator:",
                             list("\\t (tab)"=1, "' ' (space)"=2, ", (comma)"=3, "; (semicolon)"=4)))
        )
    )
)
