% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{slideMA}
\alias{slideMA}
\title{Create a moving average for a period before or after each time point for a
given variable}
\usage{
slideMA(data, Var, GroupVar, periodBound = -3, offset = 1, NewVar,
  reminder = TRUE)
}
\arguments{
\item{data}{a data frame object.}

\item{Var}{a character string naming the variable you would like to create
the lag/lead moving averages from.}

\item{GroupVar}{a character string naming the variable grouping the units
within which \code{Var} will be turned into slid moving averages. If
\code{GroupVar} is missing then the whole variable is slid up or down and
moving averages will be created. This is similar to \code{\link{shift}},
though \code{shift} returns the slid data to a new vector rather than the
original data frame.}

\item{periodBound}{integer. The time point for the outer bound of the time
period over which to create the moving averages. The default is \code{-3},
i.e. the moving average period begins three time points before a given time
point. Can also be positive for leading moving averages.}

\item{offset}{integer. How many time increments away from a given time point
to begin the moving average time period. The default is \code{1}. Effectively
controls how wide the moving average window is in the other direction of
\code{periodBound}. Note: must be positive.}

\item{NewVar}{a character string specifying the name for the new variable to
place the slid data in.}

\item{reminder}{logical. Whether or not to remind you to order your data by
the \code{GroupVar} and time variable before running \code{slideMA}.}
}
\value{
a data frame
}
\description{
Create a moving average for a period before or after each time point for a
given variable
}
\details{
\code{slideMA} is designed to give you more control over the window
for creating the moving average. Think of the \code{periodBound} and
\code{offset} arguments working together. If for example,
\code{periodBound = -3} and \code{offset = 1} then the variable of interest
will be lagged by 2 then a moving average window of three time increments
around the lagged variable is found.
}
\examples{
 # Create dummy data
 A <- B <- C <- sample(1:20, size = 20, replace = TRUE)
 ID <- sort(rep(seq(1:4), 5))
 Data <- data.frame(ID, A, B, C)

 # Lead the variable by two time units
 DataSlidMA1 <- slideMA(Data, Var = 'A', NewVar = 'ALead_MA',
                 periodBound = 3)

 # Lag the variable one time unit by ID group
 DataSlidMA2 <- slideMA(data = Data, Var = 'B', GroupVar = 'ID',
                NewVar = 'BLag_MA', periodBound = -3, offset = 2)

}
\seealso{
\code{\link{shift}}, \code{\link{slide}}, \code{\link{dplyr}}
}

