% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.r
\name{plot_density}
\alias{plot_density}
\title{Plot density estimates}
\usage{
plot_density(data, binary_as_factor = TRUE, geom_density_args = list(),
  title = NULL, ggtheme = theme_gray(), theme_config = list(),
  nrow = 4L, ncol = 4L, parallel = FALSE)
}
\arguments{
\item{data}{input data}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{geom_density_args}{a list of other arguments to \link{geom_density}}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page. Default is 4.}

\item{ncol}{number of columns per page. Default is 4.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot density estimates for each continuous feature
}
\examples{
# Plot iris data
plot_density(iris, nrow = 2L, ncol = 2L)

# Plot random data
set.seed(1)
data <- data.frame(replicate(16L, rnorm(100)))
plot_density(data)

# Add color to density area
plot_density(data, geom_density_args = list("fill" = "black", "alpha" = 0.6))
}
\seealso{
\link{geom_density} \link{plot_histogram}
}
\keyword{plot_density}
