% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataversion.r
\name{assert_data_version}
\alias{assert_data_version}
\title{Assert that a data version in a data package matches an expectation.}
\usage{
assert_data_version(
  data_package_name = NULL,
  version_string = NULL,
  acceptable = "equal",
  ...
)
}
\arguments{
\item{data_package_name}{\code{character} Name of the package.}

\item{version_string}{\code{character} Version string in "x.y.z" format.}

\item{acceptable}{\code{character} one of "equal", "equal_or_greater", describing what version match is acceptable.}

\item{...}{additional arguments passed to data_version (such as lib.loc)}
}
\value{
invisible \code{logical} TRUE if success, otherwise stop on mismatch.
}
\description{
Assert that a data version in a data package matches an expectation.
}
\details{
Tests the DataVersion string in \code{data_package_name} against \code{version_string} testing the major, minor and revision portion.

Tests "data_package_name version equal version_string" or "data_package_name version equal_or_greater version_string".
}
\examples{
if(rmarkdown::pandoc_available()){
f <- tempdir()
f <- file.path(f, "foo.Rmd")
con <- file(f)
writeLines("```{r}\n tbl = table(sample(1:10,1000,replace=TRUE)) \n```\n",con = con)
close(con)
pname <- basename(tempfile())
datapackage_skeleton(name = pname,
   path=tempdir(),
   force = TRUE,
   r_object_names = "tbl",
   code_files = f)
package_build(file.path(tempdir(),pname), install = FALSE)

devtools::load_all(file.path(tempdir(),pname))

assert_data_version(data_package_name = pname,version_string = "0.1.0",acceptable = "equal")
}
}
