% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Drivers.R
\name{downloadJdbcDrivers}
\alias{downloadJdbcDrivers}
\title{Download DatabaseConnector JDBC Jar files}
\usage{
downloadJdbcDrivers(
  dbms,
  pathToDriver = Sys.getenv("DATABASECONNECTOR_JAR_FOLDER"),
  method = "auto",
  ...
)
}
\arguments{
\item{dbms}{The type of DBMS to download Jar files for.
\itemize{
    \item{"postgresql" for PostgreSQL}
    \item{"redshift" for Amazon Redshift}
    \item{"sql server", "pdw" or "synapse" for Microsoft SQL Server}
    \item{"oracle" for Oracle}
    \item{"spark" for Spark}
    \item{"snowflake" for Snowflake}
}}

\item{pathToDriver}{The full path to the folder where the JDBC driver .jar files should be downloaded to.
By default the value of the environment variable "DATABASECONNECTOR_JAR_FOLDER" is used.}

\item{method}{The method used for downloading files. See \code{?download.file} for details and options.}

\item{...}{Further arguments passed on to \code{download.file}}
}
\value{
Invisibly returns the destination if the download was successful.
}
\description{
Download the DatabaseConnector JDBC drivers from https://ohdsi.github.io/DatabaseConnectorJars/
}
\details{
The following versions of the JDBC drivers are currently used:
\itemize{
  \item{PostgreSQL}{V42.2.18}
  \item{RedShift}{V2.1.0.9}
  \item{SQL Server}{V8.4.1.zip}
  \item{Oracle}{V19.8}
  \item{Spark}{V2.6.21}
  \item{Snowflake}{V3.13.22}
}
}
\examples{
\dontrun{
downloadJdbcDrivers("redshift")
}
}
