/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.starschema.clouddb.jdbc.BQConnection;
import net.starschema.clouddb.jdbc.BQDatabaseMetadata;
import net.starschema.clouddb.jdbc.BQForwardOnlyResultSet;
import net.starschema.clouddb.jdbc.BQQueryParser;
import net.starschema.clouddb.jdbc.BQSQLException;
import net.starschema.clouddb.jdbc.BQSQLFeatureNotSupportedException;
import net.starschema.clouddb.jdbc.BQScrollableResultSet;
import net.starschema.clouddb.jdbc.BQSupportFuncts;
import net.starschema.clouddb.jdbc.Logger;
import org.antlr.runtime.tree.Tree;

public abstract class BQStatementRoot {
    ResultSet resset = null;
    int updateCount = 0;
    String ProjectId = null;
    Logger logger = Logger.getLogger(BQStatementRoot.class.getName());
    boolean closed = false;
    BQConnection connection;
    int querytimeout = Integer.MAX_VALUE;
    long starttime = 0L;
    int resultMaxRowCount = 0x7FFFFFFE;
    boolean EscapeProc = false;
    int resultSetType;
    int resultSetConcurrency;
    private int maxFieldSize = 0;

    public void addBatch(String arg0) throws SQLException {
        throw new BQSQLException("Not implemented.addBatch(string)");
    }

    public void cancel() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("cancel()");
    }

    public void clearBatch() throws SQLException {
        throw new BQSQLException("Not implemented.clearBatch()");
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        this.closed = true;
        if (this.resset != null) {
            this.resset.close();
        }
    }

    public boolean execute(String arg0) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        String normalizedUpdateSql = this.normalizeDataDefinitionForParsing(arg0);
        Tree dataDefinitionTree = this.tryParseDataDefinition(normalizedUpdateSql);
        if (dataDefinitionTree != null || this.isSupportedDML(normalizedUpdateSql)) {
            this.updateCount = this.executeUpdate(arg0);
            return false;
        }
        this.resset = this.executeQuery(arg0);
        this.logger.info("Executing Query: " + arg0);
        return this.resset != null;
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("execute(String, int)");
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("execute(string,int[])");
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("execute(string,string[])");
    }

    public int[] executeBatch() throws SQLException {
        throw new BQSQLException("Not implemented.executeBatch()");
    }

    public ResultSet executeQuery(String querySql) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        this.starttime = System.currentTimeMillis();
        if (this.isNextvalQuery(querySql)) {
            return this.executeNextvalQuery(querySql);
        }
        BQQueryParser parser = new BQQueryParser(querySql, this.connection);
        querySql = parser.parse();
        return this.runQueryJob(querySql);
    }

    private ResultSet runQueryJob(String querySql) throws SQLException {
        Job referencedJob;
        try {
            referencedJob = BQSupportFuncts.startQuery(this.connection.getBigquery(), this.ProjectId, querySql, this.connection.getDataSet(), this.connection.getUseLegacySql(), this.connection.getMaxBillingBytes());
            this.logger.info("BQStatementRoot::runQueryJob: " + querySql);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + querySql, e);
        }
        try {
            do {
                if (BQSupportFuncts.getQueryState(referencedJob, this.connection.getBigquery(), this.ProjectId).equals("DONE")) {
                    if (this.resultSetType == 1004) {
                        return new BQScrollableResultSet(BQSupportFuncts.getQueryResults(this.connection.getBigquery(), this.ProjectId, referencedJob), this);
                    }
                    return new BQForwardOnlyResultSet(this.connection.getBigquery(), this.ProjectId.replace("__", ":").replace("_", "."), referencedJob, this);
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + querySql, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        throw new BQSQLException("Query run took more than the specified timeout");
    }

    public int executeUpdate(String updateSql) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        this.starttime = System.currentTimeMillis();
        String normalizedUpdateSql = this.normalizeDataDefinitionForParsing(updateSql);
        Tree dataDefinitionTree = this.tryParseDataDefinition(normalizedUpdateSql);
        if (dataDefinitionTree != null) {
            return this.executeDataDefinition(dataDefinitionTree, normalizedUpdateSql);
        }
        return this.runUpdateJob(updateSql);
    }

    private int runUpdateJob(String updateSql) throws BQSQLException {
        Job referencedJob;
        try {
            referencedJob = BQSupportFuncts.startQuery(this.connection.getBigquery(), this.ProjectId, updateSql, this.connection.getDataSet(), false, this.connection.getMaxBillingBytes());
            this.logger.info("BQStatementRoot::runUpdateJob: " + updateSql);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the update: " + updateSql, e);
        }
        Job pollJob = null;
        try {
            do {
                if ((pollJob = BQSupportFuncts.getQueryJob(referencedJob, this.connection.getBigquery(), this.ProjectId)).getStatus().getState().equals("DONE")) {
                    if (pollJob.getStatus().getErrors() == null) {
                        return pollJob.getStatistics().getQuery().getNumDmlAffectedRows().intValue();
                    }
                    throw new BQSQLException("Error during update: " + pollJob.getStatus().getErrors().toString());
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the update: " + updateSql, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (pollJob != null) {
            try {
                BQSupportFuncts.cancelQuery(pollJob, this.connection.getBigquery(), this.ProjectId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new BQSQLException("Update run took more than the specified timeout");
    }

    protected Tree tryParseDataDefinition(String normalizedUpdateSql) {
        BQQueryParser parser = new BQQueryParser(normalizedUpdateSql, this.connection);
        return parser.parseDataDefinition();
    }

    protected String normalizeDataDefinitionForParsing(String updateSql) {
        updateSql = updateSql.replaceAll("--[^\\n\\r]*\\r?\\n", "");
        return updateSql.replaceAll("/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/", "");
    }

    protected boolean isSupportedDML(String sql) {
        String normalized_sql = sql.trim().toLowerCase();
        return normalized_sql.startsWith("insert") || normalized_sql.startsWith("update") || normalized_sql.startsWith("delete");
    }

    private void verifyChildText(Tree tree, int i, String expected_text) throws SQLException {
        String text = tree.getChild(i).getText();
        if (!text.equalsIgnoreCase(expected_text)) {
            throw new BQSQLException("Parse error: expected \"" + expected_text + "\" got \"" + text + '\"');
        }
    }

    protected int executeDataDefinition(Tree tree, String updateSql) throws SQLException {
        switch (tree.getText()) {
            case "CREATETABLESTATEMENT": {
                return this.executeCreateTable(tree);
            }
            case "DROPTABLESTATEMENT": {
                return this.executeDropTable(tree, updateSql);
            }
            case "TRUNCATETABLESTATEMENT": {
                return this.executeTruncateTable(tree);
            }
            case "INSERTFROMSELECTSTATEMENT": {
                return this.executeInsertFromSelect(tree, updateSql);
            }
            case "SELECTINTOSTATEMENT": {
                return this.executeSelectIntoStatement(tree, updateSql);
            }
        }
        throw new BQSQLFeatureNotSupportedException(updateSql);
    }

    protected int executeCreateTable(Tree tree) throws SQLException {
        TableSchema schema = new TableSchema();
        Tree table_name_tree = tree.getChild(0);
        if (table_name_tree.getText() != "SOURCETABLE" || table_name_tree.getChildCount() != 2) {
            throw new BQSQLException("Error with table name in CREATE TABLE");
        }
        String dataSetId = table_name_tree.getChild(0).getText();
        String tableId = table_name_tree.getChild(1).getText();
        ArrayList<TableFieldSchema> tableFieldSchema = new ArrayList<TableFieldSchema>();
        for (int i = 1; i < tree.getChildCount(); ++i) {
            String type_name;
            Tree treeChild = tree.getChild(i);
            if (treeChild.getChildCount() < 2) {
                throw new BQSQLException("Error with CREATE TABLE column definition " + i);
            }
            TableFieldSchema schema_entry = new TableFieldSchema();
            schema_entry.setName(treeChild.getChild(0).getText());
            switch (type_name = treeChild.getChild(1).getText().toLowerCase()) {
                case "integer": 
                case "date": 
                case "datetime": 
                case "timestamp": 
                case "time": 
                case "float": 
                case "string": {
                    schema_entry.setType(type_name);
                    break;
                }
                case "char": 
                case "varchar": 
                case "text": {
                    schema_entry.setType("string");
                    break;
                }
                case "int": 
                case "bigint": {
                    schema_entry.setType("integer");
                    break;
                }
                case "real": {
                    schema_entry.setType("float");
                    break;
                }
                default: {
                    throw new BQSQLException("Invalid type in create table: " + type_name);
                }
            }
            if (treeChild.getChildCount() == 3) {
                this.verifyChildText(treeChild, 2, "null");
            } else if (treeChild.getChildCount() == 4) {
                this.verifyChildText(treeChild, 2, "not");
                this.verifyChildText(treeChild, 3, "null");
                schema_entry.setMode("REQUIRED");
            }
            tableFieldSchema.add(schema_entry);
        }
        schema.setFields(tableFieldSchema);
        Table table = new Table();
        table.setSchema(schema);
        TableReference tableRef = new TableReference();
        tableRef.setDatasetId(dataSetId);
        tableRef.setProjectId(this.ProjectId);
        tableRef.setTableId(tableId);
        table.setTableReference(tableRef);
        try {
            this.connection.getBigquery().tables().insert(this.ProjectId, dataSetId, table).execute();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to CREATE TABLE: ", e);
        }
        return 0;
    }

    private int executeDropTable(Tree tree, String updateSql) throws SQLException {
        Tree table_name_tree = tree.getChild(0);
        if (table_name_tree.getText() != "SOURCETABLE" || table_name_tree.getChildCount() != 2) {
            throw new BQSQLException("Error with table name in DROP TABLE: " + updateSql);
        }
        String dataSetId = table_name_tree.getChild(0).getText();
        String tableId = table_name_tree.getChild(1).getText();
        boolean if_exists = false;
        if (tree.getChildCount() == 3 && tree.getChild(1).getText().equalsIgnoreCase("if") && tree.getChild(2).getText().equalsIgnoreCase("exists")) {
            if_exists = true;
        }
        boolean found = false;
        try {
            this.connection.getBigquery().tables().get(this.ProjectId, dataSetId, tableId).execute();
            found = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!found) {
            if (if_exists) {
                return 0;
            }
            throw new BQSQLException("Failed to DROP non-existent table: " + dataSetId + "." + tableId);
        }
        try {
            this.connection.getBigquery().tables().delete(this.ProjectId, dataSetId, tableId).execute();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to DROP TABLE: ", e);
        }
        return 0;
    }

    private int executeTruncateTable(Tree tree) throws SQLException {
        Tree table_name_tree = tree.getChild(0);
        if (table_name_tree.getText() != "SOURCETABLE" || table_name_tree.getChildCount() != 2) {
            throw new BQSQLException("Error with table name in TRUNCATE TABLE");
        }
        String dataSetId = table_name_tree.getChild(0).getText();
        String tableId = table_name_tree.getChild(1).getText();
        Table table = null;
        try {
            table = (Table)this.connection.getBigquery().tables().get(this.ProjectId, dataSetId, tableId).execute();
        }
        catch (IOException e) {
            throw new BQSQLException("Table not found for TRUNCATE: ", e);
        }
        int numRows = table.getNumRows().intValue();
        try {
            this.connection.getBigquery().tables().delete(this.ProjectId, dataSetId, tableId).execute();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to TRUNCATE TABLE: ", e);
        }
        try {
            Table table_copy = new Table();
            table_copy.setSchema(table.getSchema());
            TableReference tableRef = new TableReference();
            tableRef.setDatasetId(dataSetId);
            tableRef.setProjectId(this.ProjectId);
            tableRef.setTableId(tableId);
            table_copy.setTableReference(tableRef);
            this.connection.getBigquery().tables().insert(this.ProjectId, dataSetId, table_copy).execute();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to TRUNCATE TABLE: ", e);
        }
        return numRows;
    }

    private void executeSelectWithDestination(String selectQuery, String destinationDataSet, String destinationTableId, boolean destinationAppend) throws SQLException {
        Job referencedJob;
        try {
            referencedJob = BQSupportFuncts.startQueryWithDestination(this.connection.getBigquery(), this.ProjectId, selectQuery, this.connection.getDataSet(), false, this.connection.getMaxBillingBytes(), destinationDataSet, destinationTableId, destinationAppend);
            this.logger.info("BQStatementRoot::executeSelectWithDestination: " + selectQuery);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + selectQuery, e);
        }
        try {
            do {
                Job pollJob;
                if ((pollJob = BQSupportFuncts.getQueryJob(referencedJob, this.connection.getBigquery(), this.ProjectId)).getStatus().getState().equals("DONE")) {
                    if (pollJob.getStatus().getErrors() == null) {
                        return;
                    }
                    throw new BQSQLException("Error during update: " + pollJob.getStatus().getErrors().toString());
                }
                Thread.sleep(500L);
                this.logger.debug("slept for 500ms, querytimeout is: " + this.querytimeout + "s");
            } while (System.currentTimeMillis() - this.starttime <= (long)this.querytimeout * 1000L);
        }
        catch (IOException e) {
            throw new BQSQLException("Something went wrong with the query: " + selectQuery, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        throw new BQSQLException("Query run took more than the specified timeout");
    }

    private List<TableFieldSchema> getTableFields(String dataSet, String tableId) throws BQSQLException {
        try {
            Table table = (Table)this.connection.getBigquery().tables().get(this.ProjectId, dataSet, tableId).execute();
            return table.getSchema().getFields();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to lookup table: " + dataSet + "." + tableId, e);
        }
    }

    private int getNumRows(String dataSet, String tableId) throws BQSQLException {
        try {
            Table table = (Table)this.connection.getBigquery().tables().get(this.ProjectId, dataSet, tableId).execute();
            return table.getNumRows().intValue();
        }
        catch (IOException e) {
            throw new BQSQLException("Failed to lookup table: " + dataSet + "." + tableId, e);
        }
    }

    private String getStandardTypeFromLegacyType(String type) {
        switch (type.toLowerCase()) {
            case "integer": {
                return "int64";
            }
            case "float": {
                return "float64";
            }
        }
        return type;
    }

    private int executeInsertFromSelect(Tree tree, String updateSql) throws SQLException {
        Tree table_name_tree = tree.getChild(0);
        if (table_name_tree.getText() != "SOURCETABLE" || table_name_tree.getChildCount() != 2) {
            throw new BQSQLException("Error with table name in INSERT from SELECT");
        }
        String dataSetId = table_name_tree.getChild(0).getText();
        String tableId = table_name_tree.getChild(1).getText();
        Tree selectNode = tree.getChild(1);
        if (!selectNode.getText().equalsIgnoreCase("select")) {
            throw new BQSQLException("Error with table name in INSERT from SELECT");
        }
        String selectQuery = updateSql.substring(selectNode.getCharPositionInLine());
        ArrayList<String> declared_dest_column_names = new ArrayList<String>();
        for (int i = 2; i < tree.getChildCount(); ++i) {
            declared_dest_column_names.add(tree.getChild(i).getText());
        }
        Random random = new Random();
        String tempDataSet = "temp";
        String tempTableid = "t" + (random.nextLong() & 0xFFFFFFFFL);
        this.executeSelectWithDestination(selectQuery, "temp", tempTableid, false);
        List<TableFieldSchema> temp_columns = this.getTableFields("temp", tempTableid);
        if (temp_columns.size() != declared_dest_column_names.size()) {
            throw new BQSQLException("Mismatch in declared and actual columns executing INSERT from SELECT");
        }
        List<TableFieldSchema> dest_columns = this.getTableFields(dataSetId, tableId);
        String temp_select_list = "";
        block1: for (TableFieldSchema dest_column : dest_columns) {
            for (int i = 0; i < declared_dest_column_names.size(); ++i) {
                if (!((String)declared_dest_column_names.get(i)).equals(dest_column.getName())) continue;
                temp_select_list = temp_select_list + ",cast(" + temp_columns.get(i).getName() + " as " + this.getStandardTypeFromLegacyType(dest_column.getType()) + ") as " + dest_column.getName();
                continue block1;
            }
        }
        String tempSelectQuery = "select " + temp_select_list.substring(1) + " from " + "temp" + "." + tempTableid;
        this.executeSelectWithDestination(tempSelectQuery, dataSetId, tableId, true);
        return this.getNumRows("temp", tempTableid);
    }

    private int executeSelectIntoStatement(Tree tree, String updateSql) throws SQLException {
        Tree table_name_tree = tree.getChild(0);
        if (table_name_tree.getText() != "SOURCETABLE" || table_name_tree.getChildCount() != 2) {
            throw new BQSQLException("Error with table name in INSERT from SELECT");
        }
        String dataSetId = table_name_tree.getChild(0).getText();
        String tableId = table_name_tree.getChild(1).getText();
        String selectQuery = updateSql.substring(tree.getChild(1).getCharPositionInLine());
        this.executeSelectWithDestination(selectQuery, dataSetId, tableId, false);
        return this.getNumRows(dataSetId, tableId);
    }

    protected boolean isNextvalQuery(String querySql) {
        return querySql.contains("select nextval");
    }

    public ResultSet executeNextvalQuery(String querySql) throws SQLException {
        String sequence_name = querySql.substring(querySql.indexOf("(") + 1, querySql.indexOf(")"));
        String update_sql = "update starschema.sequence set next_value = next_value + 1 where sequence_name=" + sequence_name;
        if (this.runUpdateJob(update_sql) != 1) {
            throw new BQSQLException("Error getting next value for sequence: " + sequence_name);
        }
        String select_query = "select next_value from starschema.sequence where sequence_name=" + sequence_name;
        return this.runQueryJob(select_query);
    }

    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("executeUpdate(String,int)");
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("executeUpdate(string,int[])");
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("execute(update(string,string[])");
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getFetchSize() throws SQLException {
        throw new BQSQLException("Not implemented.getFetchSize()");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new BQSQLFeatureNotSupportedException("getGeneratedKeys()");
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.resultMaxRowCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new BQSQLException(new SQLFeatureNotSupportedException("getMetaData()"));
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.closed) {
            throw new BQSQLException("Statement is closed.");
        }
        if (current == 1 || current == 2 || current == 3) {
            if (BQDatabaseMetadata.multipleOpenResultsSupported && (current == 2 || current == 3)) {
                throw new BQSQLFeatureNotSupportedException();
            }
            this.close();
            return false;
        }
        throw new BQSQLException("Wrong parameter.");
    }

    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        if (this.starttime == 0L) {
            return 0;
        }
        if (this.querytimeout == Integer.MAX_VALUE) {
            return 0;
        }
        if (System.currentTimeMillis() - this.starttime > (long)this.querytimeout) {
            throw new BQSQLException("Time is over");
        }
        return this.querytimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        if (this.resset != null) {
            return this.resset;
        }
        return null;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isPoolable() throws SQLException {
        throw new BQSQLException("Not implemented.isPoolable()");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void setCursorName(String arg0) throws SQLException {
        throw new BQSQLFeatureNotSupportedException("setCursorName(string)");
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        this.EscapeProc = arg0;
    }

    public void setFetchDirection(int arg0) throws SQLException {
        throw new BQSQLException("Not implemented.setFetchDirection(int)");
    }

    public void setFetchSize(int arg0) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("Statement closed");
        }
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        this.maxFieldSize = arg0;
    }

    public void setMaxRows(int arg0) throws SQLException {
        this.resultMaxRowCount = arg0 == 0 ? arg0 : 0x7FFFFFFE;
    }

    public void setPoolable(boolean arg0) throws SQLException {
        throw new BQSQLException("Not implemented.setPoolable(bool)");
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        if (this.isClosed()) {
            throw new BQSQLException("This Statement is Closed");
        }
        this.querytimeout = arg0 == 0 ? Integer.MAX_VALUE : arg0;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new BQSQLException("not found");
    }
}

