% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrpicker.R
\name{DateTimeRangePickerInput}
\alias{DateTimeRangePickerInput}
\title{Datetime range picker}
\usage{
DateTimeRangePickerInput(inputId, from = NULL, to = NULL, style = NULL)
}
\arguments{
\item{inputId}{the input slot that will be used to access the values}

\item{from, to}{initial values, either \code{POSIXct} objects, or objects
coercible to \code{POSIXct} objects;
if \code{NULL}, then \code{from} is set to the current time and \code{to}
is set to the next day at the same time}

\item{style}{inline CSS for the container}
}
\value{
An input element that can be included in a Shiny UI definition.
  This is a \code{shiny.tag.list} object.
}
\description{
A datetime range picker widget for a Shiny UI.
}
\examples{
library(DateTimeRangePicker)
library(shiny)

ui <- fluidPage(
  br(),
  sidebarLayout(
    sidebarPanel(
      width = 5,
      tags$fieldset(
        tags$legend("Click to change time"),
        DateTimeRangePickerInput(
          "dtrpicker",
          style = paste0(
            "background-color: chartreuse; ",
            "box-shadow: 0 30px 40px 0 rgba(16, 36, 94, 0.2);"
          )
        )
      )
    ),
    mainPanel(
      width = 7,
      verbatimTextOutput("dtrpicker")
    )
  )
)

server <- function(input, output){
  output[["dtrpicker"]] <- renderPrint({
    input[["dtrpicker"]]
  })
}

if(interactive()){
  shinyApp(ui, server)
}
}
