/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class FrequencyDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private IconButton options;
    private OkayCancelPanel okCancel;
    private IconButton remove;
    private IconButton Add;
    private JList freqList;
    private JScrollPane freqScroller;
    private JPanel frequencyPanel;
    private HelpButton help;
    private int digits = 1;
    private static Integer lastDigits;
    private static String lastDataName;
    private static DefaultListModel lastListModel;

    public FrequencyDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            boolean bl;
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.options = new IconButton("/icons/advanced_32.png", "Options", this, "Options");
            this.getContentPane().add((Component)this.options, new AnchorConstraint(829, 550, 966, 470, 0, 1, 1, 1));
            this.options.setPreferredSize(new Dimension(40, 41));
            this.options.setContentAreaFilled(false);
            this.okCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okCancel, new AnchorConstraint(867, 978, 963, 651, 1, 1, 1, 1));
            this.help = new HelpButton("pmwiki.php?n=Main.Frequencies");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(867, 978, 975, 23, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(397, 550, 535, 470, 1, 1, 1, 1));
            this.remove.setPreferredSize(new Dimension(40, 41));
            this.remove.setContentAreaFilled(false);
            this.Add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.Add, new AnchorConstraint(250, 550, 390, 470, 1, 1, 1, 1));
            this.Add.setPreferredSize(new Dimension(40, 41));
            this.Add.setContentAreaFilled(false);
            this.frequencyPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().add((Component)this.frequencyPanel, new AnchorConstraint(39, 978, 774, 579, 1, 1, 1, 1));
            this.frequencyPanel.setPreferredSize(new Dimension(209, 230));
            this.frequencyPanel.setLayout(borderLayout);
            this.frequencyPanel.setBorder(BorderFactory.createTitledBorder("Run Frequencies On:"));
            this.freqScroller = new JScrollPane();
            this.frequencyPanel.add((Component)this.freqScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.freqList = new DJList();
            this.freqScroller.setViewportView(this.freqList);
            this.freqList.setModel(defaultListModel);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(39, 434, 867, 23, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(215, 289));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.getJComboBox().addActionListener(this);
            if (lastDataName != null) {
                this.variableSelector.setSelectedData(lastDataName);
            }
            if (lastListModel != null && lastDataName != null) {
                this.freqList.setModel(lastListModel);
            }
            if (!(bl = this.variableSelector.removeAll((DefaultListModel)this.freqList.getModel()))) {
                this.freqList.setModel(new DefaultListModel());
            }
            if (lastDigits != null && bl) {
                this.digits = lastDigits;
            }
            this.setTitle("Run Frequencies");
            this.setMinimumSize(new Dimension(500, 300));
            this.setSize(524, 335);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.freqList.setModel(new DefaultListModel());
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Add") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.freqList.getModel()).addElement(objectArray[i]);
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.freqList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.freqList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Options") {
            boolean bl = false;
            while (!bl) {
                String string2 = JOptionPane.showInputDialog(this, "How many digits should the \npercentages be rounded to?", this.digits + "");
                if (string2.length() == 0) {
                    this.digits = 1;
                    bl = true;
                }
                try {
                    this.digits = Integer.parseInt(string2);
                    bl = true;
                }
                catch (Exception exception) {}
            }
        } else if (string == "OK") {
            if (this.freqList.getModel().getSize() == 0) {
                JOptionPane.showMessageDialog(this, "Please select some variables to\nrun frequencies on.");
                return;
            }
            String string3 = this.variableSelector.getSelectedData();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.freqList.getModel().getSize(); ++i) {
                arrayList.add(this.freqList.getModel().getElementAt(i));
            }
            this.dispose();
            Deducer.execute("frequencies(" + string3 + "[" + RController.makeRStringVector(arrayList) + "] , r.digits = " + this.digits + ")");
            lastDataName = string3;
            lastListModel = (DefaultListModel)this.freqList.getModel();
            lastDigits = new Integer(this.digits);
            Deducer.setRecentData(string3);
        }
    }
}

