/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMExplorer;
import org.rosuda.deducer.models.GLMExplorerPlots;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.LogisticBuilder;
import org.rosuda.deducer.models.LogisticDialog;
import org.rosuda.deducer.models.LogisticExplorerRoc;
import org.rosuda.deducer.models.LogisticModel;
import org.rosuda.deducer.toolkit.HelpButton;

public class LogisticExplorer
extends GLMExplorer {
    LogisticExplorer(GLMModel gLMModel) {
        super(gLMModel);
        this.setTitle("Logistic Model Explorer");
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LogisticModel");
    }

    public void updateClicked() {
        LogisticBuilder logisticBuilder = new LogisticBuilder(this.model);
        logisticBuilder.setLocationRelativeTo(this);
        logisticBuilder.setVisible(true);
        WindowTracker.addWindow(logisticBuilder);
        this.dispose();
    }

    public void plotsClicked() {
        JDialog jDialog;
        String string = (String)JOptionPane.showInputDialog(this.plots, "Please select the type of plot", "Plot Type", 3, null, new String[]{"Effect", "ROC"}, "Effect");
        if (string == null) {
            return;
        }
        if (string.equals("Effect")) {
            jDialog = new GLMExplorerPlots(this, this.model, this.pre);
            jDialog.setLocationRelativeTo(this);
            jDialog.setVisible(true);
        }
        if (string.equals("ROC")) {
            jDialog = new LogisticExplorerRoc(this, (LogisticModel)this.model);
            jDialog.setLocationRelativeTo(this.plots);
            jDialog.setVisible(true);
        }
        this.setModel(this.model);
    }

    public void run() {
        this.model.run(false, this.pre);
        this.dispose();
        LogisticDialog.setLastModel(this.model);
        Deducer.timedEval("suppressWarnings(rm('" + this.pre.data.split("\\$")[1] + "','" + this.pre.modelName.split("\\$")[1] + "',envir=" + Deducer.guiEnv + "))");
    }
}

