/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

class ArrayListTransferHandler
extends TransferHandler {
    DataFlavor localArrayListFlavor;
    DataFlavor serialArrayListFlavor;
    String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    static JList source = null;
    static JList target = null;
    int[] indices = null;
    int addIndex = -1;
    int addCount = 0;
    int dragMode = 3;

    public ArrayListTransferHandler() {
        try {
            this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.serialArrayListFlavor = new DataFlavor(ArrayList.class, "ArrayList");
    }

    public void setTransferMode(int n) {
        this.dragMode = n;
    }

    public int getTransferMode() {
        return this.dragMode;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        ArrayList arrayList;
        block11: {
            target = null;
            arrayList = null;
            if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            try {
                target = (JList)jComponent;
                if (this.hasLocalArrayListFlavor(transferable.getTransferDataFlavors())) {
                    arrayList = (ArrayList)transferable.getTransferData(this.localArrayListFlavor);
                    break block11;
                }
                if (this.hasSerialArrayListFlavor(transferable.getTransferDataFlavors())) {
                    arrayList = (ArrayList)transferable.getTransferData(this.serialArrayListFlavor);
                    break block11;
                }
                return false;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        int n = target.getSelectedIndex();
        DefaultListModel defaultListModel = (DefaultListModel)target.getModel();
        int n2 = defaultListModel.getSize();
        if (n < 0) {
            n = n2;
        } else if (n > n2) {
            n = n2;
        }
        if (source != null && source.equals(target) && this.indices != null && n >= this.indices[0] - 1 && n <= this.indices[this.indices.length - 1]) {
            this.indices = null;
            return true;
        }
        this.addIndex = n;
        this.addCount = arrayList.size();
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultListModel.add(n++, arrayList.get(i));
        }
        return true;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 && this.indices != null) {
            int n2;
            DefaultListModel defaultListModel = (DefaultListModel)source.getModel();
            if (source != null && source.equals(target) && this.addCount > 0) {
                for (n2 = 0; n2 < this.indices.length; ++n2) {
                    if (this.indices[n2] <= this.addIndex) continue;
                    int n3 = n2;
                    this.indices[n3] = this.indices[n3] + this.addCount;
                }
            }
            for (n2 = this.indices.length - 1; n2 >= 0; --n2) {
                defaultListModel.remove(this.indices[n2]);
            }
        }
        this.indices = null;
        target = null;
        source = null;
        this.addIndex = -1;
        this.addCount = 0;
    }

    private boolean hasLocalArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.localArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(this.localArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerialArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.serialArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(this.serialArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.hasLocalArrayListFlavor(dataFlavorArray)) {
            return true;
        }
        return this.hasSerialArrayListFlavor(dataFlavorArray);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof JList) {
            source = (JList)jComponent;
            this.indices = source.getSelectedIndices();
            Object[] objectArray = source.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string = object.toString();
                if (string == null) {
                    string = "";
                }
                arrayList.add(string);
            }
            return new ArrayListTransferable(arrayList);
        }
        return null;
    }

    public int getSourceActions(JComponent jComponent) {
        return this.dragMode;
    }

    public class ArrayListTransferable
    implements Transferable {
        ArrayList data;

        public ArrayListTransferable(ArrayList arrayList) {
            this.data = arrayList;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor, ArrayListTransferHandler.this.serialArrayListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (ArrayListTransferHandler.this.localArrayListFlavor.equals(dataFlavor)) {
                return true;
            }
            return ArrayListTransferHandler.this.serialArrayListFlavor.equals(dataFlavor);
        }
    }
}

