/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.SaveData;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.deducer.JGRConsolePlaceholder;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.data.DataFrameSelector;
import org.rosuda.deducer.data.DataFrameWindow;
import org.rosuda.deducer.menu.ContingencyDialog;
import org.rosuda.deducer.menu.CorDialog;
import org.rosuda.deducer.menu.DescriptivesDialog;
import org.rosuda.deducer.menu.FactorDialog;
import org.rosuda.deducer.menu.FrequencyDialog;
import org.rosuda.deducer.menu.KSampleDialog;
import org.rosuda.deducer.menu.MergeDialog;
import org.rosuda.deducer.menu.OneSampleDialog;
import org.rosuda.deducer.menu.RecodeDialog;
import org.rosuda.deducer.menu.SortDialog;
import org.rosuda.deducer.menu.SubsetDialog;
import org.rosuda.deducer.menu.TransformDialog;
import org.rosuda.deducer.menu.twosample.TwoSampleDialog;
import org.rosuda.deducer.models.GLMDialog;
import org.rosuda.deducer.models.LinearDialog;
import org.rosuda.deducer.models.LogisticDialog;
import org.rosuda.deducer.toolkit.DeducerPrefs;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.PrefPanel;
import org.rosuda.deducer.toolkit.VariableSelectionDialog;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.util.Platform;

public class Deducer {
    ConsoleListener cListener = new ConsoleListener();
    static final int MENUMODIFIER = Common.isMac() ? 4 : 2;
    static int menuIndex = 3;
    static String recentActiveData = "";
    static final String Version = "0.3-0";
    public static String guiEnv = "gui.working.env";
    public static boolean insideJGR;
    public static boolean started;
    public static JRIEngine engine;

    public Deducer(boolean bl) {
        started = false;
        try {
            if (bl && ((JRIEngine)JGR.getREngine()).getRni() != null) {
                new Thread(){

                    public void run() {
                        Deducer.this.startWithJGR();
                    }
                }.start();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void startNoJGR() {
        try {
            insideJGR = false;
            String string = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Platform.initPlatform("org.rosuda.JGR.toolkit.");
            try {
                engine = new JRIEngine(Rengine.getMainEngine());
            }
            catch (REngineException rEngineException) {
                new ErrorMsg((Exception)rEngineException);
            }
            Common.getScreenRes();
            JGR.setREngine((REngine)engine);
            JGR.MAINRCONSOLE = new JGRConsolePlaceholder(engine);
            JGR.MAINRCONSOLE.setVisible(false);
            JGR.STARTED = true;
            DeducerPrefs.initialize();
            started = true;
            Deducer.eval(".javaGD.set.class.path(\"org/rosuda/JGR/JavaGD\")");
            new Thread(new DataRefresher()).start();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void startWithJGR() {
        insideJGR = true;
        engine = (JRIEngine)JGR.getREngine();
        String string = "Data";
        String string2 = "Analysis";
        try {
            Container container;
            DeducerPrefs.initialize();
            if (DeducerPrefs.SHOWDATA) {
                Deducer.insertMenu((JFrame)JGR.MAINRCONSOLE, string, menuIndex);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Edit Factor", "factor", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Recode Variables", "recode", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Transform", "transform", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Reset Row Names", "reset rows", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Sort", "sort", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Transpose", "trans", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Merge Data", "merge", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string, "Subset", "subset", this.cListener);
                ++menuIndex;
            }
            if (DeducerPrefs.SHOWANALYSIS) {
                Deducer.insertMenu((JFrame)JGR.MAINRCONSOLE, string2, menuIndex);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Frequencies", "frequency", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Descriptives", "descriptives", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Contingency Tables", "contingency", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string2).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "One Sample Test", "onesample", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Two Sample Test", "two sample", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "K-Sample Test", "ksample", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Correlation", "corr", this.cListener);
                EzMenuSwing.getMenu((JFrame)JGR.MAINRCONSOLE, string2).addSeparator();
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Linear Model", "linear", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Logistic Model", "logistic", this.cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, string2, "Generalized Linear Model", "glm", this.cListener);
                ++menuIndex;
            }
            if (DeducerPrefs.VIEWERATSTARTUP) {
                container = new DataFrameWindow();
                ((Window)container).setLocationRelativeTo(null);
                ((Window)container).setVisible(true);
                JGR.MAINRCONSOLE.toFront();
            }
            if (DeducerPrefs.USEQUAQUACHOOSER && Common.isMac()) {
                Deducer.rniEval(".jChooserMacLAF()");
            }
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(menuIndex).remove(1);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "Packages & Data", "Data Viewer", "table", this.cListener, 1);
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).remove(0);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "New Data", "New Data Set", this.cListener, 0);
            JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).remove(1);
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "Open Data", "Open Data Set", this.cListener, 1);
            container = (JMenuItem)JGR.MAINRCONSOLE.getJMenuBar().getMenu(0).getMenuComponent(1);
            ((JMenuItem)container).setAccelerator(KeyStroke.getKeyStroke(76, MENUMODIFIER));
            Deducer.insertJMenuItem((JFrame)JGR.MAINRCONSOLE, "File", "Save Data", "Save Data Set", this.cListener, 2);
            EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, "Help", "Deducer Help", "dhelp", this.cListener);
            PrefPanel prefPanel = new PrefPanel();
            PrefDialog.addPanel((PrefDialog.PJPanel)prefPanel, (ActionListener)prefPanel);
            new Thread(new DataRefresher()).start();
            started = true;
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public static boolean isJGR() {
        return insideJGR;
    }

    public void detach() {
        JMenuBar jMenuBar = JGR.MAINRCONSOLE.getJMenuBar();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            if (!jMenuBar.getMenu(i).getText().equals("Data") && !jMenuBar.getMenu(i).getText().equals("Analysis")) continue;
            jMenuBar.remove(i);
            --i;
        }
    }

    public static void startViewerAndWait() {
        DataFrameWindow dataFrameWindow = new DataFrameWindow();
        dataFrameWindow.setLocationRelativeTo(null);
        dataFrameWindow.setVisible(true);
        while (DataFrameWindow.dataWindows.size() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String addSlashes(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '\\') {
                stringBuffer.insert(i++, '\\');
                continue;
            }
            if (stringBuffer.charAt(i) == '\"') {
                stringBuffer.insert(i++, '\\');
                continue;
            }
            if (stringBuffer.charAt(i) != '\'') continue;
            stringBuffer.insert(i++, '\\');
        }
        return stringBuffer.toString();
    }

    public static void runCmdThreaded(String string) {
        final String string2 = string;
        new Thread(){

            public void run() {
                Deducer.runCmd(string2, false);
            }
        }.start();
    }

    public static void runCmd(String string, boolean bl) {
        boolean bl2 = false;
        if (string.equals("dhelp")) {
            HelpButton.showInBrowser(HelpButton.baseUrl + "pmwiki.php?n=Main.DeducerManual");
        } else if (string.equals("New Data Set")) {
            String string2 = JOptionPane.showInputDialog("Data Name: ");
            if (string2 != null) {
                String string3 = RController.makeValidVariableName((String)string2.trim());
                JGR.MAINRCONSOLE.execute(string3 + "<-data.frame()");
                DataFrameWindow.setTopDataWindow(string3);
            }
        } else if (string.equals("Open Data Set")) {
            DataLoader dataLoader = new DataLoader();
            DataFrameWindow.setTopDataWindow(dataLoader.getDataName());
            Deducer.setRecentData(dataLoader.getDataName());
        } else if (string.equals("Save Data Set")) {
            RObject rObject = new DataFrameSelector((Frame)JGR.MAINRCONSOLE).getSelection();
            if (rObject != null) {
                SaveData saveData = new SaveData(rObject.getName());
            }
        } else if (string.equals("recode")) {
            bl2 = true;
            RecodeDialog recodeDialog = new RecodeDialog((JFrame)JGR.MAINRCONSOLE);
            recodeDialog.setLocationRelativeTo(null);
            recodeDialog.setVisible(true);
            WindowTracker.addWindow(recodeDialog);
        } else if (string.equals("transform")) {
            bl2 = true;
            TransformDialog transformDialog = new TransformDialog((JFrame)JGR.MAINRCONSOLE);
            transformDialog.setLocationRelativeTo(null);
            transformDialog.setVisible(true);
            WindowTracker.addWindow(transformDialog);
        } else if (string.equals("factor")) {
            bl2 = true;
            VariableSelectionDialog variableSelectionDialog = new VariableSelectionDialog((JFrame)JGR.MAINRCONSOLE);
            variableSelectionDialog.SetSingleSelection(true);
            variableSelectionDialog.setLocationRelativeTo(null);
            variableSelectionDialog.setRFilter("is.factor");
            variableSelectionDialog.setTitle("Select Factor to Edit");
            variableSelectionDialog.setVisible(true);
            String string4 = variableSelectionDialog.getSelecteditem();
            if (string4 == null) {
                return;
            }
            FactorDialog factorDialog = new FactorDialog((JFrame)JGR.MAINRCONSOLE, string4);
            factorDialog.setLocationRelativeTo(null);
            factorDialog.setVisible(true);
            WindowTracker.addWindow(factorDialog);
        } else if (string.equals("reset rows")) {
            String string5 = null;
            RObject rObject = null;
            DataFrameSelector dataFrameSelector = new DataFrameSelector((Frame)JGR.MAINRCONSOLE);
            rObject = dataFrameSelector.getSelection();
            if (rObject != null) {
                string5 = rObject.getName();
                JGR.MAINRCONSOLE.executeLater("rownames(" + string5 + ") <-1:dim(" + string5 + ")[1]");
                DataFrameWindow.setTopDataWindow(string5);
            }
            JGR.MAINRCONSOLE.toFront();
        } else if (string.equals("sort")) {
            bl2 = true;
            SortDialog sortDialog = new SortDialog((JFrame)JGR.MAINRCONSOLE);
            sortDialog.setLocationRelativeTo(null);
            sortDialog.setVisible(true);
            WindowTracker.addWindow(sortDialog);
        } else if (string.equals("merge")) {
            bl2 = true;
            MergeDialog mergeDialog = new MergeDialog((JFrame)JGR.MAINRCONSOLE);
            mergeDialog.setLocationRelativeTo(null);
            mergeDialog.setVisible(true);
            WindowTracker.addWindow(mergeDialog);
        } else if (string.equals("trans")) {
            String string6 = null;
            RObject rObject = null;
            DataFrameSelector dataFrameSelector = new DataFrameSelector((Frame)JGR.MAINRCONSOLE);
            rObject = dataFrameSelector.getSelection();
            if (rObject != null) {
                string6 = rObject.getName();
                JGR.MAINRCONSOLE.executeLater(string6 + "<-as.data.frame(t(" + string6 + "))");
                DataFrameWindow.setTopDataWindow(string6);
                JGR.MAINRCONSOLE.toFront();
            }
        } else if (string.equals("subset")) {
            bl2 = true;
            SubsetDialog subsetDialog = new SubsetDialog((JFrame)JGR.MAINRCONSOLE);
            subsetDialog.setLocationRelativeTo(null);
            subsetDialog.setVisible(true);
            JGR.MAINRCONSOLE.toFront();
            WindowTracker.addWindow(subsetDialog);
        } else if (string.equals("frequency")) {
            bl2 = true;
            FrequencyDialog frequencyDialog = new FrequencyDialog((JFrame)JGR.MAINRCONSOLE);
            WindowTracker.addWindow(frequencyDialog);
            frequencyDialog.setLocationRelativeTo(null);
            frequencyDialog.setVisible(true);
        } else if (string.equals("descriptives")) {
            bl2 = true;
            DescriptivesDialog descriptivesDialog = new DescriptivesDialog((JFrame)JGR.MAINRCONSOLE);
            descriptivesDialog.setLocationRelativeTo(null);
            descriptivesDialog.setVisible(true);
            WindowTracker.addWindow(descriptivesDialog);
        } else if (string.equals("contingency")) {
            bl2 = true;
            ContingencyDialog contingencyDialog = new ContingencyDialog((JFrame)JGR.MAINRCONSOLE);
            contingencyDialog.setLocationRelativeTo(null);
            contingencyDialog.setVisible(true);
            WindowTracker.addWindow(contingencyDialog);
        } else if (string.equals("table")) {
            bl2 = true;
            DataFrameWindow dataFrameWindow = new DataFrameWindow();
            dataFrameWindow.setLocationRelativeTo(null);
            dataFrameWindow.setVisible(true);
            WindowTracker.addWindow(dataFrameWindow);
        } else if (string.equals("onesample")) {
            bl2 = true;
            OneSampleDialog oneSampleDialog = new OneSampleDialog((JFrame)JGR.MAINRCONSOLE);
            oneSampleDialog.setLocationRelativeTo((Component)JGR.MAINRCONSOLE);
            oneSampleDialog.setVisible(true);
            WindowTracker.addWindow(oneSampleDialog);
        } else if (string.equals("two sample")) {
            bl2 = true;
            TwoSampleDialog twoSampleDialog = new TwoSampleDialog((JFrame)JGR.MAINRCONSOLE);
            twoSampleDialog.setLocationRelativeTo(null);
            twoSampleDialog.setVisible(true);
            WindowTracker.addWindow(twoSampleDialog);
        } else if (string.equals("ksample")) {
            bl2 = true;
            KSampleDialog kSampleDialog = new KSampleDialog((JFrame)JGR.MAINRCONSOLE);
            kSampleDialog.setLocationRelativeTo(null);
            kSampleDialog.setVisible(true);
            WindowTracker.addWindow(kSampleDialog);
        } else if (string.equals("corr")) {
            bl2 = true;
            CorDialog corDialog = new CorDialog((JFrame)JGR.MAINRCONSOLE);
            corDialog.setLocationRelativeTo(null);
            corDialog.setVisible(true);
            WindowTracker.addWindow(corDialog);
        } else if (string.equals("glm")) {
            bl2 = true;
            GLMDialog gLMDialog = new GLMDialog((JFrame)JGR.MAINRCONSOLE);
            gLMDialog.setLocationRelativeTo(null);
            gLMDialog.setVisible(true);
            WindowTracker.addWindow(gLMDialog);
        } else if (string.equals("logistic")) {
            bl2 = true;
            LogisticDialog logisticDialog = new LogisticDialog((JFrame)JGR.MAINRCONSOLE);
            logisticDialog.setLocationRelativeTo(null);
            logisticDialog.setVisible(true);
            WindowTracker.addWindow(logisticDialog);
        } else if (string.equals("linear")) {
            bl2 = true;
            LinearDialog linearDialog = new LinearDialog((JFrame)JGR.MAINRCONSOLE);
            linearDialog.setLocationRelativeTo(null);
            linearDialog.setVisible(true);
            WindowTracker.addWindow(linearDialog);
        }
        if (bl2 && bl && !Deducer.isJGR()) {
            WindowTracker.waitForAllClosed();
        }
    }

    public static void insertMenu(JFrame jFrame, String string, int n) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenu jMenu = EzMenuSwing.getMenu(jFrame, string);
        if (jMenu == null && n < jMenuBar.getMenuCount()) {
            JMenuBar jMenuBar2 = new JMenuBar();
            int n2 = jMenuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    jMenuBar2.add(new JMenu(string));
                }
                jMenuBar2.add(jMenuBar.getMenu(0));
            }
            jFrame.setJMenuBar(jMenuBar2);
        } else if (jMenu == null && n == jMenuBar.getMenuCount()) {
            EzMenuSwing.addMenu(jFrame, string);
        }
    }

    public static void insertJMenuItem(JFrame jFrame, String string, String string2, String string3, ActionListener actionListener, int n) {
        JMenu jMenu = EzMenuSwing.getMenu(jFrame, string);
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setActionCommand(string3);
        jMenu.insert(jMenuItem, n);
    }

    public static String getRecentData() {
        return recentActiveData;
    }

    public static void setRecentData(String string) {
        recentActiveData = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static REXP rniEval(String string) {
        REXP rEXP;
        boolean bl = engine.getRni().getRsync().safeLock();
        try {
            rEXP = engine.getRni().eval(string);
        }
        finally {
            if (bl) {
                engine.getRni().getRsync().unlock();
            }
        }
        return rEXP;
    }

    public static REXP rniIdleEval(String string) {
        return engine.getRni().idleEval(string);
    }

    public static org.rosuda.REngine.REXP eval(String string) {
        if (engine == null) {
            try {
                engine = new JRIEngine(Rengine.getMainEngine());
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
        }
        try {
            return engine.parseAndEval(string);
        }
        catch (REngineException rEngineException) {
            new ErrorMsg((Exception)rEngineException);
            return null;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg((Exception)rEXPMismatchException);
            return null;
        }
    }

    public static org.rosuda.REngine.REXP idleEval(String string) {
        if (engine == null) {
            try {
                engine = new JRIEngine(Rengine.getMainEngine());
            }
            catch (REngineException rEngineException) {
                rEngineException.printStackTrace();
            }
        }
        try {
            int n = engine.tryLock();
            if (n == 0) {
                return null;
            }
            org.rosuda.REngine.REXP rEXP = engine.parseAndEval(string);
            engine.unlock(n);
            return rEXP;
        }
        catch (REngineException rEngineException) {
            new ErrorMsg((Exception)rEngineException);
            return null;
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg((Exception)rEXPMismatchException);
            return null;
        }
    }

    public static void execute(String string) {
        JGR.MAINRCONSOLE.execute(string);
    }

    public static void execute(String string, boolean bl) {
        JGR.MAINRCONSOLE.execute(string, bl);
    }

    public static void executeAndContinue(String string) {
        final String string2 = string;
        new Thread(){

            public void run() {
                JGR.MAINRCONSOLE.execute(string2);
            }
        }.start();
    }

    public static String makeFormula(DefaultListModel defaultListModel, DefaultListModel defaultListModel2) {
        int n;
        String string = "";
        if (defaultListModel.getSize() == 1) {
            string = string + defaultListModel.get(0) + " ~ ";
        } else {
            string = string + "cbind(";
            for (n = 0; n < defaultListModel.getSize(); ++n) {
                string = string + defaultListModel.get(n);
                if (n >= defaultListModel.getSize() - 1) continue;
                string = string + ",";
            }
            string = string + ") ~ ";
        }
        for (n = 0; n < defaultListModel2.getSize(); ++n) {
            string = string + defaultListModel2.get(n);
            if (n >= defaultListModel2.getSize() - 1) continue;
            string = string + " + ";
        }
        return string;
    }

    public static String makeRCollection(Collection collection, String string, boolean bl) {
        String string2 = "";
        if (bl) {
            string2 = "\"";
        }
        if (collection.size() == 0) {
            return string + "()";
        }
        String string3 = string + "(";
        Iterator iterator = collection.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            String string4 = iterator.next().toString();
            string3 = string3 + string2 + string4 + string2;
            if (iterator.hasNext()) {
                string3 = string3 + ",";
            }
            if (n % 10 == 9) {
                string3 = string3 + "\n";
            }
            ++n;
        }
        return string3 + ")";
    }

    public static String makeRCollection(ListModel listModel, String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < listModel.getSize(); ++i) {
            arrayList.add(listModel.getElementAt(i));
        }
        return Deducer.makeRCollection(arrayList, string, bl);
    }

    public static String getUniqueName(String string, String string2) {
        return JGR.MAINRCONSOLE.getUniqueName(string, string2);
    }

    public static boolean isInstalled(String string) {
        org.rosuda.REngine.REXP rEXP = Deducer.eval("'" + string + "' %in% installed.packages()[,1]");
        if (rEXP != null && rEXP instanceof REXPLogical) {
            return ((REXPLogical)rEXP).isTRUE()[0];
        }
        return false;
    }

    public static boolean isLoaded(String string) {
        org.rosuda.REngine.REXP rEXP = Deducer.eval("'" + string + "' %in% c(names(sessionInfo()$otherPkgs), sessionInfo()$base)");
        if (rEXP != null && rEXP instanceof REXPLogical) {
            return ((REXPLogical)rEXP).isTRUE()[0];
        }
        return false;
    }

    public static String requirePackage(String string) {
        if (Deducer.isLoaded(string)) {
            return "loaded";
        }
        if (Deducer.isInstalled(string)) {
            return "installed";
        }
        int n = JOptionPane.showOptionDialog(null, "Package " + string + " not installed. \nWould you like to install it now?", "Install", 0, 3, null, new String[]{"Yes", "No"}, "Yes");
        if (n == 0) {
            Deducer.eval("install.packages('" + string + "')");
            if (Deducer.isInstalled(string)) {
                return "installed";
            }
        }
        return "not-installed";
    }

    public static String getUniqueName(String string) {
        return JGR.MAINRCONSOLE.getUniqueName(string);
    }

    public static void refreshData() {
        org.rosuda.REngine.REXP rEXP = Deducer.eval(".getDataObjects()");
        if (rEXP != null) {
            JGR.DATA.clear();
        }
        try {
            String[] stringArray;
            if (rEXP != null && !rEXP.isNull() && (stringArray = rEXP.asStrings()) != null) {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl = stringArray[i].equals("null") || stringArray[i].trim().length() == 0;
                    String string = bl ? n + "" : stringArray[i];
                    JGR.DATA.add(RController.createRObject((String)string, (String)stringArray[++i], null, (!bl ? 1 : 0) != 0));
                    ++n;
                }
            }
        }
        catch (REXPMismatchException rEXPMismatchException) {
            // empty catch block
        }
    }

    public static Vector getData() {
        return JGR.DATA;
    }

    class DataRefresher
    implements Runnable {
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        Deducer.refreshData();
                    }
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                    continue;
                }
                break;
            }
        }
    }

    class ConsoleListener
    implements ActionListener {
        ConsoleListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Deducer.runCmdThreaded(string);
        }
    }
}

