/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import edu.cens.spatial.CoordViewFactory;
import edu.cens.spatial.SpatialDataViewFactory;
import edu.cens.spatial.SpatialMenuListener;
import edu.cens.spatial.SpatialVariableViewFactory;
import edu.cens.spatial.plots.SpatialPlotBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.JGR;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataViewerController;
import org.rosuda.deducer.data.DataViewerTabFactory;
import org.rosuda.ibase.toolkit.EzMenuSwing;

public class DeducerSpatial {
    public static ActionListener cListener = new SpatialMenuListener();

    public static void init() {
        try {
            if (Deducer.isJGR()) {
                int n = 6;
                DeducerSpatial.insertMenu((JFrame)JGR.MAINRCONSOLE, "Spatial", n);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Load shape file", (String)"shape", (ActionListener)cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Convert data.frame", (String)"conv_pnt", (ActionListener)cListener);
                EzMenuSwing.addJMenuItem((JFrame)JGR.MAINRCONSOLE, (String)"Spatial", (String)"Spatial plot builder", (String)"builder", (ActionListener)cListener);
            }
            DataViewerController.init();
            DataViewerController.addDataType((String)"SpatialPointsDataFrame", (String)"sp-p");
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPointsDataFrame", (String)"Coordinates", (DataViewerTabFactory)new CoordViewFactory(false));
            DataViewerController.addDataType((String)"SpatialPolygonsDataFrame", (String)"sp-py");
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialPolygonsDataFrame", (String)"Centroids", (DataViewerTabFactory)new CoordViewFactory(false));
            DataViewerController.addDataType((String)"SpatialLinesDataFrame", (String)"sp-l");
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Data View", (DataViewerTabFactory)new SpatialDataViewFactory());
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Variable View", (DataViewerTabFactory)new SpatialVariableViewFactory());
            DataViewerController.addTabFactory((String)"SpatialLinesDataFrame", (String)"Paths", (DataViewerTabFactory)new CoordViewFactory(true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean rgdalCheck() {
        if (!Deducer.isLoaded((String)"rgdal")) {
            if (Deducer.isInstalled((String)"rgdal")) {
                Deducer.execute((String)"library(rgdal)");
                return true;
            }
            int n = JOptionPane.showOptionDialog(null, "The package rgdal is required for most functionality in Deducer Spatial. Would you like to install it now?", "Install", 0, 3, null, new String[]{"Yes", "No"}, "Yes");
            if (n == 0) {
                if (System.getProperty("os.name").startsWith("Mac")) {
                    Deducer.execute((String)"setRepositories(ind=c(9,2))\ninstall.packages('rgdal')\nlibrary(rgdal)");
                } else {
                    Deducer.execute((String)"install.packages('rgdal')\nlibrary(rgdal)");
                }
            }
            return false;
        }
        return true;
    }

    public static void insertMenu(JFrame jFrame, String string, int n) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenu jMenu = EzMenuSwing.getMenu((JFrame)jFrame, (String)string);
        if (jMenu == null && n < jMenuBar.getMenuCount()) {
            JMenuBar jMenuBar2 = new JMenuBar();
            int n2 = jMenuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    jMenuBar2.add(new JMenu(string));
                }
                jMenuBar2.add(jMenuBar.getMenu(0));
            }
            jFrame.setJMenuBar(jMenuBar2);
        } else if (jMenu == null && n == jMenuBar.getMenuCount()) {
            EzMenuSwing.addMenu((JFrame)jFrame, (String)string);
        }
    }

    public static void main(String[] stringArray) {
        final SpatialPlotBuilder spatialPlotBuilder = new SpatialPlotBuilder();
        JPanel jPanel = new JPanel();
        jPanel.add(new JButton("subset"){
            {
                super(string);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        spatialPlotBuilder.beginSubsetting();
                    }
                });
            }
        });
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add((Component)spatialPlotBuilder.getContentPane(), "Center");
        jFrame.add((Component)jPanel, "South");
        jFrame.setVisible(true);
    }
}

