/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.plots.ElementModel;
import javax.swing.JDialog;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamColor;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamRObject;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionDialog;

public class LinesElementModel
extends ElementModel {
    RFunction rf;

    public LinesElementModel() {
        this.init();
    }

    public void init() {
        this.rf = new RFunction("plot");
        ParamRObject paramRObject = new ParamRObject("x");
        paramRObject.setTitle("Spatial lines");
        paramRObject.setRObjectClass("SpatialLinesDataFrame");
        paramRObject.setRequired(true);
        this.rf.add((Param)paramRObject);
        ParamLogical paramLogical = new ParamLogical("add");
        paramLogical.setDefaultValue(false);
        paramLogical.setValue(true);
        paramLogical.setViewType("org.rosuda.deducer.widgets.param.ParamNullWidget");
        this.rf.add((Param)paramLogical);
        ParamNumeric paramNumeric = new ParamNumeric("lty");
        paramNumeric.setTitle("Type");
        paramNumeric.setLowerBound(0.5);
        paramNumeric.setUpperBound(25.5);
        paramNumeric.setOptions(new String[]{"0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0"});
        paramNumeric.setLabels(new String[]{"blank", "solid", "dashed", "dotted", "dot dash", "long dash", "two dash"});
        paramNumeric.setValue(1.0);
        paramNumeric.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramNumeric.setRequired(false);
        this.rf.add((Param)paramNumeric);
        paramNumeric = new ParamNumeric("lwd");
        paramNumeric.setTitle("Width");
        paramNumeric.setDefaultValue(1.0);
        paramNumeric.setLowerBound(0.0);
        paramNumeric.setValue(1.0);
        this.rf.add((Param)paramNumeric);
        ParamColor paramColor = new ParamColor("col");
        paramColor.setTitle("Color");
        paramColor.setRequired(false);
        this.rf.add((Param)paramColor);
        this.iconLocation = "icons/geo_path.png";
        this.name = "Lines";
    }

    public JDialog getView() {
        RFunctionDialog rFunctionDialog = new RFunctionDialog(this.rf);
        rFunctionDialog.setSize(300, 300);
        rFunctionDialog.setRun(false);
        return rFunctionDialog;
    }

    public String getCall() {
        return this.rf.getCall();
    }

    public String checkValid() {
        return this.rf.checkValid();
    }

    public LinesElementModel clone() {
        LinesElementModel linesElementModel = new LinesElementModel();
        linesElementModel.rf = (RFunction)this.rf.clone();
        return linesElementModel;
    }

    public String getDataFrameArgumentName() {
        return (String)this.rf.get(0).getValue();
    }

    public void setDataFrameArgumentName(String string) {
        this.rf.get(0).setValue((Object)string);
    }
}

