% Generated by roxygen2 (4.0.1): do not edit by hand
\name{depthContour}
\alias{depthContour}
\title{Approximate depth contours}
\usage{
depthContour(x, xlim = extendrange(x[, 1], f = 0.1), ylim = extendrange(x[,
  2], f = 0.1), n = 50, pmean = TRUE, mcol = "blue", pdmedian = TRUE,
  mecol = "brown", legend = TRUE, points = FALSE, ...)
}
\arguments{
\item{x}{Bivariate data}

\item{xlim}{Determines the width of x-axis.}

\item{ylim}{Determines the width of y-axis.}

\item{n}{Number of points in each coordinate direction to be used in contour plot.}

\item{pmean}{Logical. If TRUE mean will be marked.}

\item{mcol}{Determines the color of lines describing the mean.}

\item{pdmedian}{Logical. If TRUE depth median will be marked.}

\item{mecol}{Determines the color of lines describing the depth median.}

\item{legend}{Logical. If TRUE legend for mean and depth median will be drawn.}

\item{points}{Logical. If TRUE points from matrix x will be drawn.}

\item{\dots}{Any additional parameters for function depth (such as method) or graphical parameters (e.g. lwd, lty, main).}
}
\description{
Draws an approximate contours of depth for bivariate data.
}
\details{
The set of all points that have depth at least  \eqn{ \alpha  }  is called { \eqn{ \alpha - }  trimmed region}. The  \eqn{ \alpha - }  trimmed region w.r.t.  \eqn{ F }  is denoted by  \eqn{ {D}_{\alpha }(F) }  , i.e.,
 \deqn{ {D}_{\alpha }(F)=\left\{ z\in {{{R}}^{d}}:D(z,F)\ge \alpha  \right\}}.
}
\examples{
# EXAMPLE 1
x = mvrnorm(1000,c(0,0),diag(2))
depthContour(x)
#with points
depthContour(x, points = TRUE)

 #EXAMPLE 2
 data(inf.mort,maesles.imm)
 data1990=na.omit(cbind(inf.mort[,1],maesles.imm[,1]))
 depthContour(data1990, n = 50, pmean = TRUE, mcol = "blue",
 pdmedian = TRUE, mecol = "brown", legend = TRUE, points = TRUE,
 xlab="infant mortality rate per 1000 live birth",
 ylab="against masles immunized percentage", main='L2 depth,
 UN Fourth Goal 2011 year',method = "LP")
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\seealso{
\code{\link{depthPersp}}
}
\keyword{contour}
\keyword{depth}

