% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lsdSampleMaxDepth}
\alias{lsdSampleMaxDepth}
\title{Calculates the maximum sample location-scale depth}
\usage{
lsdSampleMaxDepth(x, iter = 100, eps = 1e-04, p_length = 10)
}
\arguments{
\item{x}{one dimensional vector with sample}

\item{iter}{maximum number of iterations in algorith for calculation Location-Scale Depth}

\item{eps}{tolerance level}

\item{p_length}{is the maximum length of the precision step at the end}
}
\description{
Calculates the maximum Student depth estimator of location and scale for one dimensional data (an alternative for MED and MAD or for the mean and standard deviation).
}
\details{
Calculations are based on lsdepth algorithm written by Ch. Muller.
}
\examples{
x = rnorm(100)
lsdSampleMaxDepth(x)
y = rf(100, 4,10)
lsdSampleMaxDepth(y)
}
\references{
Mizera, I., Muller, C. H., 2004. Location-scale depth (with discussion). Journal of the American Statistical Association 99, 949 - 966.
}

