% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Deriv}
\alias{Deriv}
\alias{Deriv.function}
\alias{derivatives}
\alias{simplifications}
\title{Symbollic differentiation of an expression or function}
\usage{
Deriv(f, x, env = parent.frame())
Deriv.function(f, x = names(formals(f)), env = environment(f))
}
\arguments{
\item{f}{An expression or function to be differentiated}

\item{x}{A character string with variable name with resptect to which
\code{f} must be differentiated. If \code{f} is function \code{x} is
optional and defaults to \code{names(formals(f))}}

\item{env}{An environment where the symbols and functions are searched for.
Defaults to \code{parent.frame()} for \code{f} expression and to
\code{environment(f)} if \code{f} is a function.}
}
\value{
An expression (for \code{Deriv}) or a function (for
 \code{Deriv.function}) with the derivative of \code{f}.
}
\description{
Symbollic differentiation of an expression or function
}
\details{
R already contains two differentiation functions: D and deriv.  D does
simple univariate differentiation.  "deriv" uses D do to multivariate
differentiation.  The output of "D" is an expression, whereas the output of
"deriv" is an executable function.
R's existing functions have several limitations.  They can probably be fixed,
but since they are written in C, this would probably require a lot of work.
Limitations include:
\itemize{
 \item The derivatives table can't be modified at runtime, and is only available
in C.
 \item The output of "deriv" can not be differentiated again.
 \item Neither function can substitute function calls.  eg:
	f <- function(x, y) x + y; deriv(f(x, x^2), "x")
}

So, here are the advantages and disadvantages of this implementation:
GOOD POINTS:
\itemize{
 \item It is entirely written in R, so would be easier to maintain.
 \item Can do multi-variate differentiation.
 \item Can differentiate function calls:
 \item It's easy to add custom entries to the derivatives table.  It could be
easier though... it would be nice if something like
worked, rather than the clunky function definitions.  (This is purely a
cosmetic issue, though... everything works as is.)
 \item The output is an executable function, which makes it suitable for use in
optimization problems.
}

BAD POINTS:
\itemize{
 \item Differentiating vector-valued functions doesn't work properly, since
the multiplication code doesn't know when to use scalar vs matrix
multiplication.  Unfortunately, solving this is a hard problem because
we would need to know if an arbitrary expression is a vector or not.
We would have to add extra metadata to do this.  Bottom line: can compute
gradients but not Jacobians or Hessians.
 \item Gives useless error messages when it gets stuck.  This could be fixed.
}
Two working environments derivatives and simplifications are created in the package
namescape. As their names indicates, they contain tables of derivatives and
simplification rules. A priori, user has not to manipulate them directly.
}
\examples{
\dontrun{f <- function(x) x^2}
\dontrun{Deriv.function(f)}
# function (x)
# 2 * x

\dontrun{f <- function(x, y) sin(x) * cos(y)}
\dontrun{Deriv.function(f)}
# function (x, y)
# sin(x) * (sin(y) * c(0, 1)) + cos(y) * (cos(x) * c(1, 0))

\dontrun{f_ <- Deriv.function(f)}
\dontrun{f_(3, 4)}
#              x         y
# [1,] 0.6471023 0.1068000
\dontrun{Deriv(expression(f(x, y^2)), "y")}
# expression(sin(x) * (neg.sin(y^2) * (2 * y)))

\dontrun{Deriv(expression(f(x, y^2)), c("x", "y"))}
# expression(sin(x) * (neg.sin(y^2) * (2 * (y * t(c(0, 1))))) +
#     cos(x) * t(c(1, 0)) * cos(y^2))

\dontrun{Deriv(expression(sin(x^2) * y), "x")}
# expression(cos(x^2) * (2 * x) * y)
}
\concept{
symbollic derivation
}

