% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeStatWH.R
\name{DeStatWH}
\alias{DeStatWH}
\title{Descriptive statistics}
\usage{
DeStatWH(x, dec = NULL, op = FALSE)
}
\arguments{
\item{x}{Numeric. A vector containing the data set.}

\item{dec}{Numeric. A value defined to set the number of decimals in the returns.}

\item{op}{Logical. If TRUE, returns plot, histogram, boxplot and qqnorm of the data set.}
}
\value{
If op=FALSE (defined by default), the function returns a matrix (1 row, 9 columns) with values of
the mean, the standart deviadtion, the minumun, the median, the maximum, the variance,
the variation coefficient, the first quartil value and the third quartil value of the data set.
Whereas if op=TRUE , the function returns four graphics: 1) A plot with X axis the number
of samples and Y axis the amount of values included in the data set, 2) The density histogram of data set
with a red line representing the distribution shape of the data, 3) A classical boxplot of the data,
and 4) the qqnorm plot including the qqline used to check the normal disribution in a data set through
visual inspection.
}
\description{
This function is useful to see the basic statistical information of a variable.
}
\details{
This function shows statistical values including several visual tools.
}
\examples{
#Example 1
data=c(rnorm(1000,30,10))
DeStatWH( x=data ,dec=2 )
#Example 2
DeStatWH( x=data , op=TRUE )
}
