% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peelingTwo.R
\name{peelingTwo}
\alias{peelingTwo}
\title{A Function to Apply the Peeling Algorithm in a Two Copy Number Matrices}
\usage{
peelingTwo(X, Y, posDT, k, threshold = NULL)
}
\arguments{
\item{X}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{Y}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{posDT}{A data frame containing genomic position information for the genes in X.}

\item{k}{The location (row of X and Y) containing the peak that will be peeled.}

\item{threshold}{A tuning parameter that controls the size of the peeled region.  Rows in which

rowMeans(X) - rowMeans(Y) are less than threshold will not be peeled.}
}
\value{
A list containing three elements: X, Y, and interval.  X and Y are updated versions of the
input copy number matrices X and Y in which the peak at k has been removed, and interval is genomic region
containing k.  By construction, interval cannot extend beyond the chromosome arm containing k.
}
\description{
This function applies a modified version of the peeling algorithm originally described in Walter et al.,
}
\details{
(PMID  21183584) to remove a peak from the copy number differences and define a genomic interval of interest

around the peak.
}
\examples{
luad=pD[["X"]]

 lusc=pD[["Y"]]

 posDT=pD[["posDT"]]

 kDiff=which.max(rowMeans(luad)-rowMeans(lusc))

 peeledDiff=peelingTwo(X=luad,Y=lusc,posDT=posDT,k=kDiff,threshold=NULL)

}
