% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/render_graph.R
\name{render_graph}
\alias{render_graph}
\title{Render the graph or output in various formats}
\usage{
render_graph(graph, output = "graph", width = NULL, height = NULL)
}
\arguments{
\item{graph}{a \code{dgr_graph} object, created using the \code{create_graph} function.}

\item{output}{a string specifying the output type; \code{graph} (the default) renders the graph using the \code{grViz} function, \code{DOT} outputs DOT code for the graph, and \code{SVG} provides SVG code for the rendered graph.}

\item{width}{an optional parameter for specifying the width of the resulting graphic in pixels.}

\item{height}{an optional parameter for specifying the height of the resulting graphic in pixels.}
}
\description{
Using a \code{dgr_graph} object, either render graph in the Viewer or output in various formats.
}
\examples{
\dontrun{
# Create a graph and then view it in the RStudio Viewer
nodes <-
  create_nodes(nodes = LETTERS,
               type = "letter",
               shape = sample(c("circle", "rectangle"),
                              length(LETTERS),
                              replace = TRUE),
               fillcolor = sample(c("aqua", "gray80",
                                    "pink", "lightgreen",
                                    "azure", "yellow"),
                                  length(LETTERS),
                                  replace = TRUE))

edges <-
  create_edges(from = sample(LETTERS, replace = TRUE),
               to = sample(LETTERS, replace = TRUE),
               relationship = "letter_to_letter")


graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges,
               graph_attrs = "layout = twopi",
               node_attrs = c("fontname = Helvetica",
                              "style = filled"),
               edge_attrs = c("color = gray20",
                              "arrowsize = 0.5"))

render_graph(graph)
}
}

