% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scale_nodes.R
\name{scale_nodes}
\alias{scale_nodes}
\title{Create numerical and color scales for node attributes}
\usage{
scale_nodes(nodes_df, to_scale, node_attr, range, scale_type = "linear")
}
\arguments{
\item{nodes_df}{a data frame containing, at minimum, a column that contains node IDs for the graph. Optionally, additional columns (named as Graphviz node attributes) can be included with values for the named node attribute. These data frames can be conveniently generated using the \code{create_nodes} function.}

\item{to_scale}{a vector of numerical values serving as a basis for scaling; these currently need to be of the same length and order as the node IDs in the supplied node data frame, so, it's recommended that the value be a reference to a column of values residing in \code{nodes_df}.}

\item{node_attr}{the name of the node attribute for which scaled values are to be created.}

\item{range}{a vector of 2 elements providing either lower and upper numerical or X11 color values.}

\item{scale_type}{the type of scaling to perform. Currently, \code{linear} is the only option available.}
}
\value{
a node data frame.
}
\description{
Generates either numeric or color scales for specified node attributes and applies those scales to node data frames.
}
\examples{
\dontrun{
# Add a node attribute which has values scaled to
# numeric data in another column
nodes <- create_nodes(nodes = 1:5,
                      label = FALSE,
                      type = "example",
                      data = sample(seq(1:20), 5))

nodes <- scale_nodes(nodes_df = nodes,
                     to_scale = nodes$data,
                     node_attr = "penwidth",
                     range = c(2, 5))
}
}

