% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_to_series.R
\name{add_to_series}
\alias{add_to_series}
\title{Add graph object to a graph series object}
\usage{
add_to_series(graph, graph_series)
}
\arguments{
\item{graph}{a graph object to add to the graph
series object.}

\item{graph_series}{a graph series object to which
the graph object will be added.}
}
\value{
a graph series object of type
\code{dgr_graph_1D}.
}
\description{
Add a graph object to an extant graph
series object for storage of multiple graphs across
a sequential or temporal one-dimensional array.
}
\examples{
library(magrittr)

# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_node("a") \%>\%
  add_node("b") \%>\%
  add_node("c") \%>\%
  add_edge("a", "c") \%>\%
  add_edge("a", "b") \%>\%
  add_edge("b", "c")

graph_2 <-
  graph_1 \%>\%
  add_node("d") \%>\%
  add_edge("d", "c")

graph_3 <-
  graph_2 \%>\%
  add_node("e") \%>\%
  add_edge("e", "b")

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Count the number of graphs in the graph series
graph_count(series)
#> [1] 3
}

