% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edges.R
\name{create_edges}
\alias{create_edges}
\title{Create a data frame with edges and their attributes}
\usage{
create_edges(from, to, rel = NULL, ...)
}
\arguments{
\item{from}{a vector of node ID values from which
edges are outbound. The vector length must equal
that of the \code{to} vector.}

\item{to}{a vector of node ID values to which edges
are incoming. The vector length must equal that of
the \code{from} vector.}

\item{rel}{an optional \code{rel} label for each
edge.}

\item{...}{one or more named vectors for associated
attributes.}
}
\value{
an edge data frame (edf).
}
\description{
Combine several named vectors for edges
and their attributes into a data frame, which can be
combined with other similarly-generated data frames,
or, added to a graph object.
}
\examples{
# Create a simple edge data frame (edf) and
# view the results
edges <-
  create_edges(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a")

# Display the `edges` edf
edges
#>   from to rel
#> 1    1  4   a
#> 2    2  3   a
#> 3    3  1   a

# Render the graph to make it viewable in
# the Viewer pane
render_graph(
  create_graph(edges_df = edges),
  output = "visNetwork")

# Create an edge data frame with several
# additional parameters
edges <-
  create_edges(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a",
    length = c(50, 100, 250),
    color = "green",
    width = c(1, 5, 2))

# Render the graph to make it viewable in
# the Viewer pane
render_graph(
  create_graph(edges_df = edges),
  output = "visNetwork")
}

