% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_graphs.R
\name{combine_graphs}
\alias{combine_graphs}
\title{Combine two graphs into a single graph}
\usage{
combine_graphs(x, y)
}
\arguments{
\item{x}{a \code{DiagrammeR} graph object to which
another graph will be unioned. This graph should be
considered the graph from which global graph
attributes will be inherited in the resulting graph.}

\item{y}{a \code{DiagrammeR} graph object that is to
be unioned with the graph suppled as \code{x}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Combine two graphs in order to make a
new graph.
}
\examples{
# Create a graph with a cycle with 6 nodes
graph_cycle <-
 create_graph() \%>\%
   add_cycle(n = 6)

# Create a random graph with 8 nodes, 15 edges
graph_random <-
  create_random_graph(
    8, 15, set_seed = 1)

# Combine the two graphs in a union operation
combined_graph <-
  combine_graphs(graph_cycle, graph_random)

# Get the number of nodes in the combined graph
node_count(combined_graph)
#> [1] 14

# The `combine_graphs()` function will renumber
# node ID values in graph `y` during the union;
# this ensures that node ID values are unique
get_node_ids(combined_graph)
#> [1]  1  2  3  4  5  6  7  8  9 10 11 12 13 14
}

