% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_count.R
\name{graph_count}
\alias{graph_count}
\title{Count graphs in a graph series object}
\usage{
graph_count(graph_series)
}
\arguments{
\item{graph_series}{a graph series object of type
\code{dgr_graph_1D}}
}
\value{
a numeric vector representing a count of
graphs in a graph series object.
}
\description{
Counts the total number of graphs in a
graph series object.
}
\examples{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_n_nodes(3) \%>\%
  add_edges_w_string(
    "1->3 1->2 2->3")

graph_2 <-
  graph_1 \%>\%
  add_node() \%>\%
  add_edge(4, 3)

graph_3 <-
  graph_2 \%>\%
  add_node() \%>\%
  add_edge(5, 2)

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Count the number of graphs in the graph series
graph_count(series)
#> [1] 3
}

